#!/usr/bin/python3

import os
import shlex
import shutil
import time

from common.common_define import CommonDefine
from common.logutils import Logger, SUBAGENT_INSTALL_LOG
from common.utils import Utils, log_with_exception
from common.utils import VAR_CDM_LIB_BAK
from common.utils import VAR_CDM_LOG_BAK

sub_agent_root_path = Utils.get_sub_agent_root_path()
sub_agent_path = os.path.join(sub_agent_root_path,
                              "CDMClient/HWClientService/")
log = Logger().get_logger(SUBAGENT_INSTALL_LOG)


class DbInstanceInfo(object):
    def __init__(self):
        """
        db_user:安装时输入用户
        db_path:安装时输入数据库路径
        db_application_type:PG数据库应用类型
        db_instance_path:PG数据库实例路径
        """
        self.db_user = 'root'
        self.db_path = 'null'
        self.db_application_type = '1'
        self.db_instance_path = 'null'


class DbInstallInfo(object):
    def __init__(self):
        """
        db_index:安装时选择序号，对应不同数据库
        db_instance_list:实例信息列表
        """
        self.db_index = 'false'
        self.db_instance_list = []


class SubCommonOper(object):

    @staticmethod
    def start_client(script_path, is_upgrade=False):
        if CommonDefine.IS_WINDOWS:
            script_start = os.path.join(script_path, "start.bat")
        else:
            script_start = os.path.join(script_path, "start.sh")
        if not os.path.isfile(script_start):
            log.error(f"start[{script_start}] script not exists.")
            return False
        os.chdir(script_path)
        if CommonDefine.IS_WINDOWS:
            upgrade_param = "upgrade" if is_upgrade else ""
            cmds = [f"start.bat", f"{upgrade_param}"]
            if not upgrade_param:
                cmds.pop()
        else:
            cmds = ["bash", "start.sh"]
        ret_code, _ = Utils.execute_cmd(cmds)
        os.chdir(Utils.get_install_path())
        if ret_code != 0:
            log.error(f"start agent failed.")
            return False
        return True

    @staticmethod
    def stop_client(script_path):
        if CommonDefine.IS_WINDOWS:
            script_file = "stop.bat"
        else:
            script_file = "stop.sh"
        script_stop = os.path.join(script_path, script_file)
        if os.path.exists(script_path):
            if not os.path.isfile(script_stop):
                log.error(f"stop[{script_stop}] script not exists.")
                return False
            os.chdir(script_path)
            if CommonDefine.IS_WINDOWS:
                ret_code, _ = Utils.execute_cmd([f"{script_file}"])
            else:
                ret_code, _ = Utils.execute_cmd(["bash", f"{script_file}"])
            os.chdir(Utils.get_install_path())
            if ret_code != 0:
                log.error(f"stop agent failed.")
                return False
        return True

    @staticmethod
    @log_with_exception(log)
    def clear_useless_dir(pkg_path, stop=False):
        if not os.path.exists(pkg_path):
            log.info(f"pkg_path[{pkg_path}] not exists")
            return True
        if stop:
            if not SubCommonOper.stop_client(sub_agent_path):
                log.error("stop SubAgent failed")
                return False
            time.sleep(2)
        retry_time = 0
        os.chdir(Utils.get_install_path())
        while retry_time <= 3:
            try:
                SubCommonOper.clear_dir(pkg_path)
                break
            except Exception as err:
                log.error(f"remove useless catalog failed, error:{err}")
                retry_time += 1
                time.sleep(1)
        else:
            return False
        log.info("Successfully clear useless catalog")
        return True

    @staticmethod
    def clear_dir(pkg_path):
        shutil.rmtree(pkg_path)
        if not CommonDefine.IS_WINDOWS:
            shutil.rmtree(VAR_CDM_LIB_BAK)
            shutil.rmtree(VAR_CDM_LOG_BAK)