@echo off
echo off
setlocal EnableDelayedExpansion
rem -----------------------------------------------
rem this shell for an unified installation(window)
rem -----------------------------------------------
set INSTALL_PATH=%1
set HA_PROXY_IP=%2

if not exist %~dp0\temp (
    md %~dp0\temp
)

if "%HA_PROXY_IP%" == "" (
    echo The IP address is empty.
    call :delete_temp
    exit /b 1
)

call :check_path_legality "%INSTALL_PATH%" validity
if [%validity%] equ [0] (
    echo "[%INSTALL_PATH%] is invalid, cannot contain Chinese character or space."
    call :delete_temp
    exit /b 1
)

call :check_ip "%HA_PROXY_IP%" validity
if [%validity%] neq [0] (
    echo "%HA_PROXY_IP%" is not a valid ip
    call :delete_temp
    exit /b 1
)

call :download_cert
call :delete_temp
if not exist %INSTALL_PATH%\AgentAssist\conf\cert\ca.pem (
     echo "Download Proxy Server(%HA_PROXY_IP%) ca cert failed."
     exit /b 1
)

if exist %INSTALL_PATH%\AgentAssist\conf\cert\ca.txt ( del ca.txt )

exit /b 0

:delete_temp
    if exist %~dp0\temp (
        rd /s/q %~dp0\temp
    )
    goto :EOF

:download_cert
    set CA_CERT_FILE_PATH="%INSTALL_PATH%\AgentAssist\conf\cert"
    if not exist %CA_CERT_FILE_PATH% (
        md %CA_CERT_FILE_PATH%
    )
    cd %CA_CERT_FILE_PATH%
    set INSTALL_PYTHON_PATH=%INSTALL_PATH%\AgentAssistPython
    %INSTALL_PYTHON_PATH%\openssl.exe s_client -connect  %HA_PROXY_IP%:8089 -showcerts >ca.txt 2>nul
    set /a isend=0
    set /a startR=0
    set /a endR=0
    for /f "delims=:" %%a in ('findstr /n "BEGIN CERTIFICATE" ca.txt') do (
        if !isend! == 0 (
           set /a isend=1
           set /a startR=%%~a
        ) else (
           set /a isend=0
           set /a endR=%%~a
        )
    )
    if exist %CA_CERT_FILE_PATH%\ca.pem del ca.pem
    if !startR! == 0 goto :EOF
    if !endR! == 0 goto :EOF
    type nul>ca.pem
    set /a startR=!startR! - 1
    set sRow=skip=!startR!
    set /a start=!startR!
    for /f "%sRow% tokens=* delims=" %%a in (ca.txt) do (
        set /a start+=1
        echo.%%a >>ca.pem
        if "!endR!"=="!start!" goto :EOF
    )

    goto :EOF

:check_ip <IP> <validity>
    Set "VbsFile=%~dp0temp\%~n0.vbs"
    (
        echo WScript.Echo(Is_Valid("%~1"^)^)
        echo Function Is_Valid(IP^)
        echo    Dim RegularExpressionObject
        echo    Set RegularExpressionObject = New RegExp
        echo    With RegularExpressionObject
        echo        .Pattern = "(^((25[0-5]|2[0-4]\d|1?\d?\d)\.){3}(25[0-5]|2[0-4]\d|1?\d?\d)$)|((([0-9a-fA-F]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9a-fA-F]{1,4}:){6}((([0-9]{1,3}\.){3}[0-9]{1,4})|([0-9a-fA-F]{1,4})|:))|(([0-9a-fA-F]{1,4}:){5}:((([0-9a-fA-F]{1,4})?)|([0-9a-fA-F]{1,4}:[0-9a-fA-F]{1,4})|(([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){4}:((([0-9a-fA-F]{1,4})?)|(([0-9a-fA-F]{1,4}:){1,2}[0-9a-fA-F]{1,4})|(([0-9a-fA-F]{1,4}:)?([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){3}:((([0-9a-fA-F]{1,4}:){0,2}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,3}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){2}:((([0-9a-fA-F]{1,4}:){0,3}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,4}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){1}:((([0-9a-fA-F]{1,4}:){0,4}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,5}[0-9a-fA-F]{1,4})|$))|(::((([0-9a-fA-F]{1,4}:){0,5}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,6}[0-9a-fA-F]{1,4})|$)))$"
        echo        .IgnoreCase = False
        echo        If .Test(IP^)= True then
        echo            Is_Valid = 0
        echo        Else
        echo            Is_Valid = 1
        echo        End if
        echo    End With
        echo End Function
    )>"%VbsFile%"
    @for /f "delims=" %%a in ('cscript //nologo "%VbsFile%"') do set "%2=%%a"
    Exit /B

:check_path_legality <path> <validity>
    Set "VbsFile=%~dp0temp\%~n0.vbs"
    (
        echo WScript.Echo(Is_Valid("%~1"^)^)
        echo Function Is_Valid(path^)
        echo    Dim RegularExpressionObject
        echo    Set RegularExpressionObject = New RegExp
        echo    With RegularExpressionObject
        echo        .Pattern = "[\u4e00-\u9fa5\s]+"
        echo        .IgnoreCase = False
        echo        If .Test(path^)= True then
        echo            Is_Valid = 0
        echo        Else
        echo            Is_Valid = 1
        echo        End if
        echo    End With
        echo End Function
    )>"%VbsFile%"
    @for /f "delims=" %%a in ('cscript //nologo "%VbsFile%"') do set "%2=%%a"
    Exit /B
