# -*- coding:utf-8 -*-
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.business.account_query import AccountQuery
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from utils.business.param_util import ParamUtil
from plugins.eBackup.common import constant


class ParamTool(object):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def get_account_pwd_from_unify_pwd(self, region_id, account_list,
                                       used_scene=None, component_dict=None, vm_ip=""):
        if not component_dict:
            component_dict = {"component": constant.EBACKUP_SERVICE_NAME, "sub_component": "eBackupServer"}
        account_query = AccountQuery(self.project_id, self.pod_id)
        return account_query.get_account_info(
            region_id, account_list, used_scene, component_dict.get("component"),
            component_dict.get("sub_component"), vm_ip
        )

    def get_all_region_code(self):
        region_info_list = ManageOneCmdbUtil(self.project_id, self.pod_id).get_region_info()
        return [region_info.get('regionCode') for region_info in region_info_list if region_info.get('regionCode')]

    def get_region_id(self):
        region_id = ParamUtil().get_param_value(
            self.pod_id, "public", "region_id", "region0_id")
        if not region_id:
            raise Exception("Failed to obtain the current region_id.")
        return region_id

    def is_expand_az(self):
        return get_project_condition_boolean(self.project_id, "ExpansionAZ_KVM | ExpansionAZ_BMS")

    def is_expand_ebackup_server(self):
        return get_project_condition_boolean(self.project_id, "eBackup_ServerProxy_Driver | (eBackup & !eBackup_Proxy)")

    def is_expand_ebackup_proxy(self):
        return get_project_condition_boolean(self.project_id, "eBackup_Proxy")

    def is_csha_storage(self):
        return get_project_condition_boolean(self.project_id, "CSHAStorage")

    def is_install_csbs(self):
        return get_project_condition_boolean(self.project_id, "InstallCSBS-VBS-Server")

    def is_installed_csbs(self):
        return get_project_condition_boolean(self.project_id, "InstalledCSBS-VBS | BCInstalled")

    def is_ipv6_scene(self):
        return get_project_condition_boolean(self.project_id, "ManageIPV6")
