#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

import utils.common.log as logger
from utils.business.project_util import ProjectApi
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.constant.business_constant import CMDBConstant

INSTALLED_AZ_FOR_EBACKUP = "InstalledAZForeBackup"


class CustomizeCondition:
    def __init__(self, project_id, cmdb_ins):
        self.project_id = project_id
        self.cmdb_ins = cmdb_ins
        self.project_api = ProjectApi()

    def execute(self):
        is_expand_storage = get_project_condition_boolean(self.project_id, "BCInstalled&ExpansionServiceStorage")
        is_expand_kvm = get_project_condition_boolean(self.project_id, "BCInstalled&ExpansionComputeRes_KVMNode")
        custom_condition_id = {
            INSTALLED_AZ_FOR_EBACKUP: 0
        }
        if not is_expand_storage and not is_expand_kvm:
            return json.dumps(custom_condition_id)
        cur_region_id = self.project_api.get_regionlist_by_project_Id(self.project_id)[0]
        advanced_options_dict = self.project_api.get_project_info(self.project_id).get('advanced_options', dict())
        az_id = advanced_options_dict.get("az_id")

        data_dict = self._get_ebackup_extend_info(cur_region_id)
        extend_info_list = data_dict.get("extendInfos", [])
        az_list = ""
        for extend_info in extend_info_list:
            if extend_info.get("key") == "az_list":
                az_list = extend_info.get("value", "")
                break
        logger.info(f"The eBackup az information obtained from the CMDB is '{az_list}', current az is {az_id}.")
        if az_id in az_list:
            custom_condition_id = {
                INSTALLED_AZ_FOR_EBACKUP: 1
            }
            logger.info(f"The eBackup scenario {INSTALLED_AZ_FOR_EBACKUP} is active.")
        return json.dumps(custom_condition_id)

    def _get_ebackup_extend_info(self, cur_region_id):
        cmdb_info = None
        if not self.cmdb_ins:
            raise Exception("The incoming param is not an instance of accessing the CMDB.")
        cmdb_data = self.cmdb_ins.get_region_infos(cur_region_id)
        service_info = cmdb_data.get(CMDBConstant.SERVICE_LAYER, [])
        for unit in service_info:
            if unit.get(CMDBConstant.MACHINE_NAME).startswith("eBackup_service1"):
                cmdb_info = unit
                break
        return cmdb_info
