# -*- coding: utf-8 -*-
from utils.business.param_util import HandleParamCheck
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException
from utils.common import log

from plugins.eBackup.common.params_check_tool import init_params
from plugins.eBackup.common.params_check_tool import check_ebackup_nodes
from plugins.eBackup.common.params_check_tool import check_workflow_web_login
from plugins.eBackup.common.model import SshInfo, SshParamsCheckInfo


def params_check(project_id):
    """插件参数校验接口函数

    错误信息返回值（需要中英文信息）：
    1、支持通过HCCIException(error_code, *arg, **kwargs)类获取中英文信息,此方法是获取公共方法中的错误
    2、支持通过code2Msg(error_code, *arg, **kwargs)函数获取中英文信息,此方法是获取各组件自定义的错误
    """

    db_opt = ParamUtil()
    check_data = db_opt.get_need_check_cloud_params(project_id, "eBackup")
    check_data.update({"eBackup_Workflow_nodes": ";".join([check_data.get("eBackup_Workflow_nodes"),
                                                           check_data.get("eBackup_Manager_nodes")])})
    check_result = HandleParamCheck()
    all_params = ["eBackup_Workflow_nodes", "eBackup_admin_pwd", "eBackup_hcp_pwd", "eBackup_root_pwd",
                  "eBackup_alarm_pwd"]
    args = (check_data, db_opt, project_id, check_result, all_params, 'migrate')
    init_params(*args)
    log.info("Succeed to init params.")
    workflow_abnormal_nodes_info = SshParamsCheckInfo()
    workflow_ip_list = check_data.get("eBackup_Workflow_nodes").replace(" ", "").replace("|", ";").split(";")
    ssh_info = SshInfo(workflow_ip_list, "hcp", check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"))
    check_ebackup_nodes(check_result, "eBackup_Workflow_nodes", ssh_info, workflow_abnormal_nodes_info)
    log.info("Start to check openstack param.")
    ebackup_check_param(
        check_result,
        workflow_abnormal_nodes_info.sudo_user_fail_nodes,
        workflow_abnormal_nodes_info.ssh_user_fail_nodes
    )
    # check workflow web login
    result = check_workflow_web_login(check_data, check_result, all_params)
    return result


def ebackup_check_param(check_result, unpassed_ebackup_root_nodes, unpassed_ebackup_hcp_nodes):
    if len(unpassed_ebackup_hcp_nodes) == 0:
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"], status=200, error_msg="")
    else:
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"], status=500,
                                      error_msg=HCCIException(650001, ",".join(unpassed_ebackup_hcp_nodes)))
    if len(unpassed_ebackup_root_nodes) == 0:
        check_result.set_check_result(param_keys=["eBackup_root_pwd"], status=200, error_msg="")
    else:
        check_result.set_check_result(param_keys=["eBackup_root_pwd"], status=500,
                                      error_msg=HCCIException(650002, ",".join(unpassed_ebackup_root_nodes)))
