# -*- coding:utf-8 -*-
import time
import utils.common.log as logger
from utils.business.manageone_util2 import ManageOneUtil2
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

from plugins.eBackup.common.ebackup_util import EBackupUtil
from plugins.eBackup.common.param_tool import ParamTool

logger.init("eBackup connect manageone for Datamover")


class ConfigOC(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super().__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.err_code = 0
        self.description = None
        self.param_tool = ParamTool(self.project_id, self.pod_id)
        self.ebackup = EBackupUtil(project_id, pod_id)
        self.param_util = ParamUtil()
        self.manageone = ManageOneUtil2()
        self.management_float_ip = self.ebackup.get_management_float_ip()
        self.externalom_iplist = self.ebackup.get_externalom_iplist()
        self.config_dict = self.param_util.get_service_cloud_param(pod_id, "eBackup")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.exec_config_oc()
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error("Failed to connect ManageOne(datamover) ,the reason is %s" % err)
            return Message(500, err, err)

        return Message(200)

    def exec_config_oc(self):
        if self.param_tool.is_expand_ebackup_proxy():
            return
        self.add_white_list()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def update_error_info(self, err, des):
        if self.err_code == 0:
            self.err_code = err
            self.description = des

    def add_white_list(self):
        logger.info("Add XAAS whitelist(ebackup_server) start.")
        logic_region = self.config_dict.get('region_display_name')
        is_ok = self.manageone.addXaasWhiteList(pod_id=self.pod_id, sysName="eBackup", ipList=self.externalom_iplist,
                                                region="", groupType="", logicRegion=logic_region, restProtocol="1",
                                                snmpProtocol="", floatIp=self.management_float_ip)
        if not is_ok:
            logger.error("Add XAAS whitelist(ebackup_server) failed.")
            raise HCCIException(653010, '')
        logger.info("Add XAAS whitelist succeeded.")


