# -*- coding:utf-8 -*-
import configparser
import os

import threading
import time
from utils.DBAdapter.DBConnector import BaseOps
from utils.business.param_util import ParamUtil
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.business.project_condition_utils import get_project_conditions
from utils.common import log as logger
from utils.common import network_pci_slot_mapping_util
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.param_check import ping
from utils.odkApi.odkApi import OdkApi

from plugins.eBackup.common.api_adapter import API
from plugins.eBackup.scripts.common import ebackup_util as ebackup_handle
from plugins.ResourceCheck.common.libs.ibmc_cmd_libs import IBMCOperate

logger.init("eBackup Install OS")

INSTALL_STATUS_COMPLETED = (3, 4)
INSTALL_STATUS_FAIL = 4


class ReadConfig(object):

    def __init__(self):
        cur_path = os.path.dirname(os.path.realpath(__file__))
        cur_path = os.path.dirname(cur_path)
        file_name = os.path.join(cur_path, "../conf/os_config.ini")
        self.config = configparser.ConfigParser()
        self.config.read(file_name)

    def get_os_grub_passwd(self, params):
        return self.config['grub_password'][params]


POST_SCRIPT_ARM = '''
# make /etc/rc.d/rc.local executable
chmod +x /etc/rc.d/rc.local
#service sshd open root
/usr/bin/sed -i '/PermitRootLogin/s/no/yes/' /etc/euleros_security/security.conf
# Resolving the CVE-2021-4034 Vulnerability
chmod 0755 /usr/bin/pkexec
/usr/bin/sed -i '/ALWAYS_SET_PATH/s/yes/no/' /etc/euleros_security/security.conf
#disable euler origin harden
/usr/bin/sed -i 's/^SELINUX=.*$/SELINUX=disabled/g' /etc/selinux/config

#delete useless ntp server
/usr/bin/sed -i '/^server.*$/d' /etc/ntp.conf

#set kernal parameters to disable rename nic name and make sure it will not be remove from grub.cfg file
#avoid losing config when eulerOS reset kernal parameter
#protect /tmp/upgrade/ from deleting
sed -i '/\/tmp\/upgrade/d' /usr/lib/tmpfiles.d/tmp.conf
echo 'x /tmp/upgrade' >> /usr/lib/tmpfiles.d/tmp.conf

#fix euler file bug(do not executed because bug is fixed)
l_num=`grep -n "root" /etc/sudoers | grep ALL | awk -F ':' '{printf $1}'`
sed -i "$l_num iALL     ALL=(ALL)       ALL" /etc/sudoers
sed -i "$l_num iDefaults targetpw" /etc/sudoers

#let all users (not only users in wheel group) could operate 'su'
sed -i '/auth.*required.*pam_wheel.so.*use_uid/d' /etc/pam.d/su

#make sure multipathd is stoped and disabled
chkconfig --level 35 multipathd off
systemctl disable multipathd.service
systemctl stop multipathd.service
#OS hardening: disable tribal-key function
rm -f /usr/lib/systemd/system/ctrl-alt-del.target

#OS hardening: delete compile tools
rpm -e --nodeps make
rm -rf /usr/bin/readelf /usr/bin/lua /usr/bin/perl /usr/bin/rpcgen /usr/bin/ld /usr/bin/objdump


#set onboot to no for all port files except ifcfg-lo
/usr/bin/sed -i 's/ONBOOT=yes/ONBOOT=no/' /etc/sysconfig/network-scripts/ifcfg-*
/usr/bin/sed -i 's/ONBOOT=no/ONBOOT=yes/' /etc/sysconfig/network-scripts/ifcfg-lo

#set kernal parameter to make sure /sys/module/scsi_mod/parameters/use_blk_mq is 'N'
/usr/bin/sed -i '/GRUB_CMDLINE/s/\"$/ scsi_mod.use_blk_mq=n\"/' /etc/default/grub
/usr/bin/sed -i '/vmlinuz.*/s/$/ scsi_mod.use_blk_mq=n/' /boot/efi/EFI/euleros/grub.cfg
#make sure /etc/sudoers contains "Defaults    always_set_home"
grep "^Defaults.*always_set_home" /etc/sudoers 2>&1 > /dev/null
if [[ $? != 0 ]]
then
    echo "Defaults    always_set_home" >> /etc/sudoers
fi

echo 'set enable-bracketed-paste off' >> /etc/inputrc



'''
PRE_SCRIPT_SOFT_RAID = '''
#加载额外驱动
driver_list=(
    "hinic3"
    "hisdk3"
    "hiudk3"
    "hiraid"
    "sssraid"
)

for driver in "${driver_list[@]}"; do
    ko_path=$(find /usr/lib -type f -name "${driver}*" | head -n 1)
    insmod "${ko_path}" && depmod
    modinfo "${driver}" >> /tmp/preinstall.log  2>&1
    if [ $? -ne 0 ]; then
        echo "insmod ${driver} failed!! skip."
    fi
done

cat /proc/partitions >> /tmp/partitions0
cat /proc/mdstat >> /tmp/mdstat0 
# 如果HCC框架未识别到raid卡 但是实际存在的话 添加此处保险 将其设置为硬RAID
lspci | grep -q 'RAID bus controller'  
if [ $? -eq 0 ]; then
    vg_name=VolGroup2
    vg_base_name=$vg_name
    vgdisplay | grep -w $vg_name > /dev/null 2>&1
    if [[ $? == 0 ]]
    then
        i=3
        while(true)
        do
            vg_name="$vg_base_name$i"
            vgdisplay | grep -w $vg_name > /dev/null 2>&1
            if [[ $? != 0 ]]
            then
                break
            fi
            ((i=i+1))
        done
    fi
    sys_disk_name=`fdisk -l | grep Disk | grep -wE 'GB|GiB|TiB|TB' | awk -F '/' '{print $3}' | awk -F ':' '{print $1}' | grep -v mapper | grep -vi nvme | grep -v loop | sort | sed -n '1p'`
        echo "#System bootloader configuration" >  /tmp/part-include
        echo "bootloader --append=\"crashkernel=auto\" --location=mbr --driveorder=$sys_disk_name --iscrypted --password={GRUB_PASSWD}" >> /tmp/part-include
        echo "#partitioning scheme generated in %pre for sysdisk" >> /tmp/part-include
    echo "zerombr" >> /tmp/part-include
        echo "ignoredisk --only-use=$sys_disk_name"  >> /tmp/part-include
    echo "clearpart --all --drives=$sys_disk_name " >> /tmp/part-include
    echo "part /boot --fstype=\"ext4\" --ondisk=$sys_disk_name --size=512" >> /tmp/part-include
    echo "part /boot/efi --fstype=\"efi\" --ondisk=$sys_disk_name --size=1024 --fsoptions=\"umask=0077,shortname=winnt\"" >> /tmp/part-include
    echo "part swap --fstype=\"swap\" --ondisk=$sys_disk_name --size=8192" >> /tmp/part-include
    echo "part pv.1100 --fstype=\"lvmpv\" --ondisk=$sys_disk_name --size=1 --grow" >> /tmp/part-include
    echo "volgroup $vg_name --pesize=4096 pv.1100" >> /tmp/part-include
    echo "logvol /var  --fstype=\"ext4\" --percent=30 --name=var --vgname=$vg_name" >> /tmp/part-include
    echo "logvol /tmp  --fstype=\"ext4\" --percent=4 --name=tmp --vgname=$vg_name" >> /tmp/part-include
    echo "logvol /opt  --fstype=\"ext4\" --percent=50 --name=opt --vgname=$vg_name" >> /tmp/part-include
    echo "logvol /home  --fstype=\"ext4\" --percent=4 --name=home --vgname=$vg_name" >> /tmp/part-include
    echo "logvol /usr  --fstype=\"ext4\" --percent=4 --name=usr --vgname=$vg_name" >> /tmp/part-include
    echo "logvol /  --fstype=\"ext4\" --percent=8 --name=root --vgname=$vg_name"  >> /tmp/part-include
    exit 0
fi
#使用前两张盘组raid1
sys_disk_name1=`fdisk -l | grep Disk | grep -wE 'GB|GiB|TiB|TB' | awk -F '/' '{print $3}' | awk -F ':' '{print $1}' | grep -v mapper | grep -vi nvme | grep -v loop | grep -v md | sort | sed -n '1p'`
sys_disk_name2=`fdisk -l | grep Disk | grep -wE 'GB|GiB|TiB|TB' | awk -F '/' '{print $3}' | awk -F ':' '{print $1}' | grep -v mapper | grep -vi nvme | grep -v loop | grep -v md | sort | sed -n '2p'`

#clear all vgroup
vgremove -f /dev/VolGroup2*
for vg in $(vgdisplay | grep "VG Name" | awk '{print $3}');
do
    vgremove -f /dev/${vg}*
done

#clear soft raid, try to stop 3 times
for try in {1..3}
do
    for md in $(cat /proc/mdstat | grep md | awk -F: '{print $1}')
    do
        mdadm --stop /dev/${md}
        sleep 1
    done
    md_num=$(cat /proc/mdstat | grep md | wc -l)
    if [ $md_num -eq 0 ]
    then
        echo "no md found after $try clear"
        break
    fi
done
mdadm --misc --zero-superblock /dev/${sys_disk_name1}1
mdadm --misc --zero-superblock /dev/${sys_disk_name1}2
mdadm --misc --zero-superblock /dev/${sys_disk_name1}3
for fs_sd in $(ls -1 /dev/${sys_disk_name1}*)
do
    mdadm --misc --zero-superblock /dev/${fs_sd}
done
mdadm --misc --zero-superblock /dev/${sys_disk_name2}1
mdadm --misc --zero-superblock /dev/${sys_disk_name2}2
mdadm --misc --zero-superblock /dev/${sys_disk_name2}3
for fs_sd in $(ls -1 /dev/${sys_disk_name2}*)
do
    mdadm --misc --zero-superblock /dev/${fs_sd}
done

for disk in ${sys_disk_name1} ${sys_disk_name2};do
    for p in {1..9};do
        parted /dev/${disk} -s rm $p
    done
done

cat /proc/partitions >> /tmp/partitions1
cat /proc/mdstat >> /tmp/mdstat1

vg_name=VolGroup2
vg_base_name=$vg_name
vgdisplay | grep -w $vg_name > /dev/null 2>&1
if [[ $? == 0 ]]
then
    i=3
    while(true)
    do
        vg_name="$vg_base_name$i"
        vgdisplay | grep -w $vg_name > /dev/null 2>&1
        if [[ $? != 0 ]]
        then
            break
        fi
        ((i=i+1))
    done
fi

echo "#partitioning scheme generated in %pre for sysdisk" > /tmp/part-include
echo "zerombr" >> /tmp/part-include
echo "ignoredisk --only-use=$sys_disk_name1,$sys_disk_name2"  >> /tmp/part-include
echo "clearpart --all --initlabel  --drives=$sys_disk_name1,$sys_disk_name2 " >> /tmp/part-include

echo "part raid.sd1_0 --fstype="mdmember" --ondrive=$sys_disk_name1 --size=512" >> /tmp/part-include
echo "part raid.sd2_0 --fstype="mdmember" --ondrive=$sys_disk_name2 --size=512" >> /tmp/part-include

echo "part raid.sd1_1 --fstype="mdmember" --ondrive=$sys_disk_name1 --size=1024 --fsoptions=\"umask=0077,shortname=winnt\"" >> /tmp/part-include
echo "part raid.sd2_1 --fstype="mdmember" --ondrive=$sys_disk_name2 --size=1024 --fsoptions=\"umask=0077,shortname=winnt\"" >> /tmp/part-include

echo "part raid.sd1_2 --fstype="mdmember" --ondrive=$sys_disk_name1 --size=8192" >> /tmp/part-include
echo "part raid.sd2_2 --fstype="mdmember" --ondrive=$sys_disk_name2 --size=8192" >> /tmp/part-include
echo "part raid.sd1_3 --fstype="mdmember" --ondrive=$sys_disk_name1 --size 1 --grow" >> /tmp/part-include
echo "part raid.sd2_3 --fstype="mdmember" --ondrive=$sys_disk_name2 --size 1 --grow" >> /tmp/part-include

echo "raid /boot --device=md0 --fstype=ext4 --level=RAID1 raid.sd1_0 raid.sd2_0" >> /tmp/part-include
echo "raid /boot/efi --device=md1 --fstype=efi  --level=RAID1 --fsoptions=\"umask=0077,shortname=winnt\" raid.sd1_1 raid.sd2_1" >> /tmp/part-include
echo "raid swap --device=md2 --fstype=\"swap\" --level=RAID1 raid.sd1_2 raid.sd2_2" >> /tmp/part-include
echo "raid pv.1100  --device=md3 --fstype=ext4 --level=RAID1 raid.sd1_3 raid.sd2_3" >> /tmp/part-include

echo "volgroup $vg_name --pesize=4096 pv.1100" >> /tmp/part-include
echo "logvol /var  --fstype="ext4" --percent=30 --name=var --vgname=$vg_name" >> /tmp/part-include
echo "logvol /tmp  --fstype="ext4" --percent=4 --name=tmp --vgname=$vg_name" >> /tmp/part-include
echo "logvol /opt  --fstype="ext4" --percent=50 --name=opt --vgname=$vg_name" >> /tmp/part-include
echo "logvol /home  --fstype="ext4" --percent=4 --name=home --vgname=$vg_name" >> /tmp/part-include
echo "logvol /usr  --fstype="ext4" --percent=4 --name=usr --vgname=$vg_name" >> /tmp/part-include
echo "logvol /  --fstype="ext4" --percent=8 --name=root --vgname=$vg_name"  >> /tmp/part-include

echo "#System bootloader configuration" >>  /tmp/part-include
echo "bootloader --append=\"crashkernel=auto\" --location=mbr --boot-drive=$sys_disk_name1 --driveorder=md0 --iscrypted --password={GRUB_PASSWD}" >> /tmp/part-include
echo "bootloader --append=\"crashkernel=auto\" --location=mbr --boot-drive=$sys_disk_name2 --driveorder=md0 --iscrypted --password={GRUB_PASSWD}" >> /tmp/part-include
'''
software_name_arm = {"packages":
    [
        'acl.aarch64',
        'adcli.aarch64',
        'at.aarch64',
        'attr.aarch64',
        'audit.aarch64',
        'audit-libs.aarch64',
        'authselect.aarch64',
        'avahi-libs.aarch64',
        'basesystem.noarch',
        'bash.aarch64',
        'bind.aarch64',
        'bind-libs.aarch64',
        'bind-libs-lite.aarch64',
        'brotli.aarch64',
        'bzip2.aarch64',
        'ca-certificates.noarch',
        'c-ares.aarch64',
        'checkpolicy.aarch64',
        'chkconfig.aarch64',
        'chrony.aarch64',
        'coreutils.aarch64',
        'cpio.aarch64',
        'cracklib.aarch64',
        'cronie.aarch64',
        'crontabs.noarch',
        'crypto-policies.noarch',
        'cryptsetup.aarch64',
        'cups-libs.aarch64',
        'curl.aarch64',
        'cyrus-sasl.aarch64',
        'cyrus-sasl-lib.aarch64',
        'dbus.aarch64',
        'dbus-common.noarch',
        'dbus-daemon.aarch64',
        'dbus-glib.aarch64',
        'dbus-libs.aarch64',
        'dbus-tools.aarch64',
        'dbxtool.aarch64',
        'deltarpm.aarch64',
        'device-mapper.aarch64',
        'device-mapper-event.aarch64',
        'dhcp.aarch64',
        'diffutils.aarch64',
        'ding-libs.aarch64',
        'dmidecode.aarch64',
        'dnf.noarch',
        'dnf-plugins-core.noarch',
        'dosfstools.aarch64',
        'dracut.aarch64',
        'dracut-config-rescue.aarch64',
        'dracut-network.aarch64',
        'dracut-squash.aarch64',
        'drpm.aarch64',
        'e2fsprogs.aarch64',
        'ebtables.aarch64',
        'efibootmgr.aarch64',
        'efi-filesystem.noarch',
        'efi-srpm-macros.noarch',
        'efivar.aarch64',
        'efivar-libs.aarch64',
        'elfutils.aarch64',
        'ethtool.aarch64',
        'euleros-config.aarch64',
        'euleros-gpg-keys.aarch64',
        'euleros-latest-release.aarch64',
        'euleros-logrotate.noarch',
        'euleros-release.aarch64',
        'euleros-repos.aarch64',
        'expat.aarch64',
        'expect.aarch64',
        'file.aarch64',
        'file-libs.aarch64',
        'filesystem.aarch64',
        'findutils.aarch64',
        'fipscheck.aarch64',
        'firewalld.noarch',
        'freetype.aarch64',
        'fuse.aarch64',
        'gamin.aarch64',
        'gawk.aarch64',
        'gdbm.aarch64',
        'genisoimage.aarch64',
        'GeoIP.aarch64',
        'GeoIP-GeoLite-data.noarch',
        'gettext.aarch64',
        'glib2.aarch64',
        'glibc.aarch64',
        'glibc-common.aarch64',
        'gmp.aarch64',
        'gnupg2.aarch64',
        'gnutls.aarch64',
        'gobject-introspection.aarch64',
        'gpgme.aarch64',
        'gpm-libs.aarch64',
        'grep.aarch64',
        'groff.aarch64',
        'grub2-common.noarch',
        'grub2-efi-aa64.aarch64',
        'grub2-tools.aarch64',
        'grub2-tools-extra.aarch64',
        'grub2-tools-minimal.aarch64',
        'grubby.aarch64',
        'gssproxy.aarch64',
        'gzip.aarch64',
        'hardlink.aarch64',
        'haveged.aarch64',
        'hostname.aarch64',
        'hwdata.noarch',
        'ima-evm-utils-libs.aarch64',
        'info.aarch64',
        'initscripts.aarch64',
        'iotop.noarch',
        'ipcalc.aarch64',
        'iproute.aarch64',
        'iprutils.aarch64',
        'ipset.aarch64',
        'ipset-libs.aarch64',
        'iptables.aarch64',
        'iptables-libs.aarch64',
        'iputils.aarch64',
        'irqbalance.aarch64',
        'jansson.aarch64',
        'json-c.aarch64',
        'kbd.aarch64',
        'kbd-legacy.noarch',
        'kbd-misc.noarch',
        'kbox-kmod.aarch64',
        'kernel.aarch64',
        'kernel-tools.aarch64',
        'kernel-tools-libs.aarch64',
        'kexec-tools.aarch64',
        'keyutils.aarch64',
        'keyutils.aarch64',
        'kmod.aarch64',
        'kmod-libs.aarch64',
        'kmod-megaraid_sas.aarch64',
        'kpartx.aarch64',
        'krb5.aarch64',
        'krb5-libs.aarch64',
        'ksecurec.aarch64',
        'less.aarch64',
        'libacl.aarch64',
        'libaio.aarch64',
        'libalarm.aarch64',
        'libarchive.aarch64',
        'libargon2.aarch64',
        'libassuan.aarch64',
        'libblkid.aarch64',
        'libcap.aarch64',
        'libcap-ng.aarch64',
        'libcomps.aarch64',
        'libcroco.aarch64',
        'libcurl.aarch64',
        'libdaemon.aarch64',
        'libdb.aarch64',
        'libdbi.aarch64',
        'libdnf.aarch64',
        'libedit.aarch64',
        'libestr.aarch64',
        'libev.aarch64',
        'libevent.aarch64',
        'libfastjson.aarch64',
        'libfdisk.aarch64',
        'libffi.aarch64',
        'libgcc.aarch64',
        'libgcrypt.aarch64',
        'libgomp.aarch64',
        'libgpg-error.aarch64',
        'libICE.aarch64',
        'libicu.aarch64',
        'libidn2.aarch64',
        'libkcapi.aarch64',
        'libksba.aarch64',
        'libldb.aarch64',
        'libmetalink.aarch64',
        'libmnl.aarch64',
        'libmodulemd.aarch64',
        'libmount.aarch64',
        'libndp.aarch64',
        'libnet.aarch64',
        'libnetfilter_conntrack.aarch64',
        'libnfnetlink.aarch64',
        'libnftnl.aarch64',
        'libnghttp2.aarch64',
        'libnl3.aarch64',
        'libnsl2.aarch64',
        'libpcap.aarch64',
        'libpipeline.aarch64',
        'libpng.aarch64',
        'libpsl.aarch64',
        'libpwquality.aarch64',
        'librepo.aarch64',
        'libreport-filesystem.noarch',
        'libseccomp.aarch64',
        'libsecurec.aarch64',
        'libselinux.aarch64',
        'libsemanage.aarch64',
        'libsepol.aarch64',
        'libsigsegv.aarch64',
        'libSM.aarch64',
        'libsmartcols.aarch64',
        'libsmbclient.aarch64',
        'libsolv.aarch64',
        'libssh.aarch64',
        'libstdc++.aarch64',
        'libtalloc.aarch64',
        'libtasn1.aarch64',
        'libtdb.aarch64',
        'libteam.aarch64',
        'libtevent.aarch64',
        'libtirpc.aarch64',
        'libunistring.aarch64',
        'libusal.aarch64',
        'libuser.aarch64',
        'libutempter.aarch64',
        'libuuid.aarch64',
        'libverto.aarch64',
        'libwbclient.aarch64',
        'libX11.aarch64',
        'libXau.aarch64',
        'libXaw.aarch64',
        'libxcb.aarch64',
        'libxcrypt.aarch64',
        'libXext.aarch64',
        'libxkbcommon.aarch64',
        'libxml2.aarch64',
        'libXmu.aarch64',
        'libXpm.aarch64',
        'libXt.aarch64',
        'libyaml.aarch64',
        'linux-firmware.noarch',
        'lm_sensors.aarch64',
        'lmdb.aarch64',
        'logrotate.aarch64',
        'lsscsi.aarch64',
        'lua.aarch64',
        'lvm2.aarch64',
        'lz4.aarch64',
        'lzo.aarch64',
        'man-db.aarch64',
        'mariadb-connector-c.aarch64',
        'mokutil.aarch64',
        'mozjs60.aarch64',
        'mpfr.aarch64',
        'ncurses.aarch64',
        'ncurses-base.noarch',
        'ncurses-libs.aarch64',
        'net-snmp-libs.aarch64',
        'nettle.aarch64',
        'net-tools.aarch64',
        'NetworkManager.aarch64',
        'NetworkManager-config-server.noarch',
        'NetworkManager-libnm.aarch64',
        'newt.aarch64',
        'nfs-utils.aarch64',
        'nftables.aarch64',
        'npth.aarch64',
        'numactl-libs.aarch64',
        'openEuler-rpm-config.aarch64 ',
        'openldap.aarch64',
        'openssh.aarch64',
        'openssh-clients.aarch64',
        'openssh-server.aarch64',
        'openssl.aarch64',
        'openssl-libs.aarch64',
        'openssl-perl.aarch64',
        'openssl-pkcs11.aarch64',
        'os-health-check.aarch64',
        'os-prober.aarch64',
        'p11-kit.aarch64',
        'p11-kit-trust.aarch64',
        'pam.aarch64',
        'parted.aarch64',
        'passwd.aarch64',
        'pciutils.aarch64',
        'pcre.aarch64',
        'pcre2.aarch64',
        'perl.aarch64',
        'perl-Algorithm-Diff.noarch',
        'perl-Archive-Tar.noarch',
        'perl-autodie.noarch',
        'perl-B-Debug.noarch',
        'perl-bignum.noarch',
        'perl-Carp.noarch',
        'perl-Compress-Raw-Bzip2.aarch64',
        'perl-Compress-Raw-Zlib.aarch64',
        'perl-Config-Perl-V.noarch',
        'perl-constant.noarch',
        'perl-CPAN-Meta.noarch',
        'perl-CPAN-Meta-Requirements.noarch',
        'perl-CPAN-Meta-YAML.noarch',
        'perl-Data-Dumper.aarch64',
        'perl-DB_File.aarch64',
        'perl-Devel-PPPort.aarch64',
        'perl-Digest.noarch',
        'perl-Digest-MD5.aarch64',
        'perl-Digest-SHA.aarch64',
        'perl-Encode.aarch64',
        'perl-Encode-Locale.noarch',
        'perl-Env.noarch',
        'perl-Exporter.noarch',
        'perl-File-Fetch.noarch',
        'perl-File-Temp.noarch',
        'perl-Filter.aarch64',
        'perl-Getopt-Long.noarch',
        'perl-HTTP-Tiny.noarch',
        'perl-IO-Compress.noarch',
        'perl-IO-Socket-IP.noarch',
        'perl-IO-Socket-SSL.noarch',
        'perl-libs.aarch64',
        'perl-Net-SSLeay.aarch64',
        'perl-parent.noarch',
        'perl-PathTools.aarch64',
        'perl-perlfaq.noarch',
        'perl-PerlIO-via-QuotedPrint.noarch',
        'perl-Perl-OSType.noarch',
        'perl-Pod-Checker.noarch',
        'perl-Pod-Escapes.noarch',
        'perl-podlators.noarch',
        'perl-Pod-Parser.noarch',
        'perl-Pod-Perldoc.noarch',
        'perl-Pod-Simple.noarch',
        'perl-Pod-Usage.noarch',
        'perl-Scalar-List-Utils.aarch64',
        'perl-Text-ParseWords.noarch',
        'perl-threads.aarch64',
        'perl-threads-shared.aarch64',
        'perl-Time-HiRes.aarch64',
        'perl-Time-Local.noarch',
        'perl-URI.noarch',
        'popt.aarch64',
        'procps-ng.aarch64',
        'publicsuffix-list.noarch',
        'python3-libselinux.aarch64',
        'qt5-srpm-macros.noarch',
        'quota.aarch64',
        'readline.aarch64',
        'rootfiles.noarch',
        'rpcbind.aarch64',
        'rpm.aarch64',
        'rpm-libs.aarch64',
        'rsyslog.aarch64',
        'samba-client.aarch64',
        'samba-common.aarch64',
        'security-tool.aarch64',
        'sed.aarch64',
        'selinux-policy.noarch',
        'selinux-policy-targeted.noarch',
        'setup.noarch',
        'sg3_utils.aarch64',
        'shadow.aarch64',
        'shared-mime-info.aarch64',
        'shim.aarch64',
        'slang.aarch64',
        'snappy.aarch64',
        'sqlite.aarch64',
        'squashfs-tools.aarch64',
        'sssd.aarch64',
        'sysalarm.aarch64',
        'sysfsutils.aarch64',
        'sysmonitor-kmod.aarch64',
        'sysstat.aarch64',
        'systemd.aarch64',
        'systemd-libs.aarch64',
        'systemd-udev.aarch64',
        'systemd-udev-compat.aarch64',
        'tar.aarch64',
        'tcl.aarch64',
        'thin-provisioning-tools.aarch64',
        'timedatex.aarch64',
        'traceroute.aarch64',
        'tzdata.noarch',
        'unbound-libs.aarch64',
        'unzip.aarch64',
        'util-linux.aarch64',
        'vim-common.aarch64',
        'vim-enhanced.aarch64',
        'vim-filesystem.noarch',
        'vim-minimal.aarch64',
        'wget.aarch64',
        'which.aarch64',
        'xz.aarch64',
        'xz-libs.aarch64',
        'yum.noarch',
        'zip.aarch64',
        'zlib.aarch64',
        'zstd.aarch64',
        'open-iscsi.aarch64 ',
        'network-scripts.aarch64',
        'network-scripts-teamd.aarch64',
        'dos2unix.aarch64',
        'cifs-utils.aarch64',
        'ntp.aarch64',
        'ntpstat.noarch',
        'screen.aarch64',
        'python3-unversioned-command.aarch64',
        'losf.aarch64',
        'sudo.aarch64',
    ]
}

software_name_x86 = {"packages":
    [
        'acl.x86_64',
        'aide.x86_64',
        'audit-libs.x86_64',
        'audit.x86_64',
        'autogen-libopts.x86_64',
        'avahi-libs.x86_64',
        'basesystem.noarch',
        'bash.x86_64',
        'bind-libs-lite.x86_64',
        'bind-libs.x86_64',
        'bind-utils.x86_64',
        'biosdevname.x86_64',
        'blktrace.x86_64',
        'bridge-utils.x86_64',
        'bzip2-libs.x86_64',
        'bzip2.x86_64',
        'chkconfig.x86_64',
        'cifs-utils.x86_64',
        'coreutils.x86_64',
        'cpio.x86_64',
        'cracklib-dicts.x86_64',
        'cracklib.x86_64',
        'createrepo.noarch',
        'cronie-anacron.x86_64',
        'cronie.x86_64',
        'crontabs.noarch',
        'cryptsetup-libs.x86_64',
        'cups-libs.x86_64',
        'curl.x86_64',
        'cyrus-sasl-lib.x86_64',
        'dbus-glib.x86_64',
        'dbus-libs.x86_64',
        'dbus-python.x86_64',
        'dbus.x86_64',
        'deltarpm.x86_64',
        'device-mapper-event-libs.x86_64',
        'device-mapper-event.x86_64',
        'device-mapper-libs.x86_64',
        'device-mapper-persistent-data.x86_64',
        'device-mapper.x86_64',
        'dhclient.x86_64',
        'dhcp-libs.x86_64',
        'diffutils.x86_64',
        'dmidecode.x86_64',
        'dos2unix.x86_64',
        'dracut-network.x86_64',
        'dracut.x86_64',
        'dump_mem_tool.x86_64',
        'e2fsprogs-libs.x86_64',
        'e2fsprogs.x86_64',
        'elfutils-libelf.x86_64',
        'elfutils-libs.x86_64',
        'ethtool.x86_64',
        'euleros-release.x86_64',
        'euleros-config.x86_64',
        'expat-devel.x86_64',
        'expat.x86_64',
        'expect.x86_64',
        'file-libs.x86_64',
        'filesystem.x86_64',
        'file.x86_64',
        'findutils.x86_64',
        'fipscheck-lib.x86_64',
        'fipscheck.x86_64',
        'freetype.x86_64',
        'fuse.x86_64',
        'gawk.x86_64',
        'gdbm.x86_64',
        'genisoimage.x86_64',
        'gettext-libs.x86_64',
        'gettext.x86_64',
        'glib2.x86_64',
        'glibc-common.x86_64',
        'glibc.i686',
        'glibc.x86_64',
        'gmp.x86_64',
        'gnupg2.x86_64',
        'gobject-introspection.x86_64',
        'gpgme.x86_64',
        'gpm-libs.x86_64',
        'grep.x86_64',
        'grub2-tools.x86_64',
        'grub2.x86_64',
        'grubby.x86_64',
        'gssproxy.x86_64',
        'gzip.x86_64',
        'hardlink.x86_64',
        'hdparm.x86_64',
        'hostname.x86_64',
        'hwdata.noarch',
        'info.x86_64',
        'initscripts.x86_64',
        'iotop.noarch',
        'ipmitool.x86_64',
        'iproute.x86_64',
        'iptables.x86_64',
        'iputils.x86_64',
        'irqbalance.x86_64',
        'json-c.x86_64',
        'kbox-kmod.x86_64',
        'kernel-tools-libs.x86_64',
        'kernel-tools.x86_64',
        'kernel.x86_64',
        'kexec-tools.x86_64',
        'keyutils-libs.x86_64',
        'keyutils.x86_64',
        'kmod-libs.x86_64',
        'kmod.x86_64',
        'kpartx.x86_64',
        'kpatch-runtime.noarch',
        'krb5-libs.x86_64',
        'less.x86_64',
        'libacl.x86_64',
        'libaio.x86_64',
        'libalarm.x86_64',
        'libassuan.x86_64',
        'libattr.x86_64',
        'libbasicobjects.x86_64',
        'libblkid.x86_64',
        'libcap-ng.x86_64',
        'libcap.x86_64',
        'libcgroup-tools.x86_64',
        'libcgroup.x86_64',
        'libcollection.x86_64',
        'libcom_err.x86_64',
        'libcroco.x86_64',
        'libcurl.x86_64',
        'libdb-utils.x86_64',
        'libdb.x86_64',
        'libedit.x86_64',
        'libestr.x86_64',
        'libevent.x86_64',
        'libffi.x86_64',
        'libgcc.x86_64',
        'libgcrypt.x86_64',
        'libgomp.x86_64',
        'libgpg-error.x86_64',
        'libidn.x86_64',
        'libini_config.x86_64',
        'libldb.x86_64',
        'libmnl.x86_64',
        'libmount.x86_64',
        'libnetfilter_conntrack.x86_64',
        'libnfnetlink.x86_64',
        'libnfsidmap.x86_64',
        'libpath_utils.x86_64',
        'libpcap.x86_64',
        'libpciaccess.x86_64',
        'libpwquality.x86_64',
        'libref_array.x86_64',
        'libsecurec.x86_64',
        'ksecurec.x86_64',
        'libselinux.x86_64',
        'libsemanage.x86_64',
        'libsepol.x86_64',
        'libssh2.x86_64',
        'libss.x86_64',
        'libstdc++.x86_64',
        'libsysfs.x86_64',
        'libtalloc.x86_64',
        'libtasn1.x86_64',
        'libtdb.x86_64',
        'libtevent.x86_64',
        'libtirpc.x86_64',
        'libunistring.x86_64',
        'libusal.x86_64',
        'libuser.x86_64',
        'libutempter.x86_64',
        'libuuid.x86_64',
        'libverto-tevent.x86_64',
        'libverto.x86_64',
        'libwbclient.x86_64',
        'libxml2-python.x86_64',
        'libxml2.x86_64',
        'libxslt.x86_64',
        'linux-firmware.noarch',
        'lm_sensors-libs.x86_64',
        'logrotate.x86_64',
        'lsof.x86_64',
        'lsscsi.x86_64',
        'lua.x86_64',
        'lvm2-libs.x86_64',
        'lvm2.x86_64',
        'lzo.x86_64',
        'mailcap.noarch',
        'mailx.x86_64',
        'makedumpfile.x86_64',
        'man-db.x86_64',
        'mcelog.x86_64',
        'mtools.x86_64',
        'ncurses-base.noarch',
        'ncurses-libs.x86_64',
        'ncurses.x86_64',
        'net-snmp-libs.x86_64',
        'net-tools.x86_64',
        'nfs-utils.x86_64',
        'nscd.x86_64',
        'nspr.x86_64',
        'nss-softokn-freebl.i686',
        'nss-softokn-freebl.x86_64',
        'nss-softokn.x86_64',
        'nss-sysinit.x86_64',
        'nss-tools.x86_64',
        'nss-util.x86_64',
        'nss.x86_64',
        'ntpdate.x86_64',
        'ntp.x86_64',
        'numactl-libs.x86_64',
        'numactl.x86_64',
        'numad.x86_64',
        'OpenIPMI-libs.x86_64',
        'OpenIPMI-modalias.x86_64',
        'OpenIPMI.x86_64',
        'openldap.x86_64',
        'openssh-clients.x86_64',
        'openssh-server.x86_64',
        'openssh.x86_64',
        'openssl-libs.x86_64',
        'openssl.x86_64',
        'p11-kit-trust.x86_64',
        'p11-kit.x86_64',
        'pam.x86_64',
        'parted.x86_64',
        'passwd.x86_64',
        'pciutils-libs.x86_64',
        'pciutils.x86_64',
        'pcre.x86_64',
        'perl-Business-ISBN-Data.noarch',
        'perl-Business-ISBN.noarch',
        'perl-Carp.noarch',
        'perl-Compress-Raw-Bzip2.x86_64',
        'perl-Compress-Raw-Zlib.x86_64',
        'perl-Config-IniFiles.noarch',
        'perl-constant.noarch',
        'perl-Data-Dumper.x86_64',
        'perl-DBD-SQLite.x86_64',
        'perl-DBI.x86_64',
        'perl-Digest-MD5.x86_64',
        'perl-Digest.noarch',
        'perl-Digest-SHA.x86_64',
        'perl-Encode-Locale.noarch',
        'perl-Encode.x86_64',
        'perl-Exporter.noarch',
        'perl-File-Listing.noarch',
        'perl-File-Path.noarch',
        'perl-File-Temp.noarch',
        'perl-Filter.x86_64',
        'perl-Getopt-Long.noarch',
        'perl-HTML-Parser.x86_64',
        'perl-HTML-Tagset.noarch',
        'perl-HTTP-Cookies.noarch',
        'perl-HTTP-Daemon.noarch',
        'perl-HTTP-Date.noarch',
        'perl-HTTP-Message.noarch',
        'perl-HTTP-Negotiate.noarch',
        'perl-HTTP-Tiny.noarch',
        'perl-IO-Compress.noarch',
        'perl-IO-HTML.noarch',
        'perl-IO-Socket-IP.noarch',
        'perl-IO-Socket-SSL.noarch',
        'perl-libs.x86_64',
        'perl-libwww-perl.noarch',
        'perl-List-MoreUtils.x86_64',
        'perl-LWP-MediaTypes.noarch',
        'perl-macros.x86_64',
        'perl-Net-Daemon.noarch',
        'perl-Net-HTTP.noarch',
        'perl-Net-LibIDN.x86_64',
        'perl-Net-SSLeay.x86_64',
        'perl-parent.noarch',
        'perl-PathTools.x86_64',
        'perl-PlRPC.noarch',
        'perl-Pod-Escapes.noarch',
        'perl-podlators.noarch',
        'perl-Pod-Perldoc.noarch',
        'perl-Pod-Simple.noarch',
        'perl-Pod-Usage.noarch',
        'perl-Scalar-List-Utils.x86_64',
        'perl-Socket.x86_64',
        'perl-Storable.x86_64',
        'perl-Text-ParseWords.noarch',
        'perl-threads-shared.x86_64',
        'perl-threads.x86_64',
        'perl-TimeDate.noarch',
        'perl-Time-HiRes.x86_64',
        'perl-Time-Local.noarch',
        'perl-URI.noarch',
        'perl-WWW-RobotRules.noarch',
        'perl.x86_64',
        'perl-XML-LibXML.x86_64',
        'perl-XML-NamespaceSupport.noarch',
        'perl-XML-SAX-Base.noarch',
        'perl-XML-SAX.noarch',
        'pinentry.x86_64',
        'pkgconfig.x86_64',
        'popt.x86_64',
        'procps-ng.x86_64',
        'psmisc.x86_64',
        'pth.x86_64',
        'pygobject3-base.x86_64',
        'pygpgme.x86_64',
        'pyliblzma.x86_64',
        'pytalloc.x86_64',
        'python-backports-ssl_match_hostname.noarch',
        'python-backports.x86_64',
        'python-configobj.noarch',
        'python-decorator.noarch',
        'python-deltarpm.x86_64',
        'python-iniparse.noarch',
        'python-libs.x86_64',
        'python-pycurl.x86_64',
        'python-pyudev.noarch',
        'python-setuptools.noarch',
        'python-urlgrabber.noarch',
        'python.x86_64',
        'pyxattr.x86_64',
        'qrencode-libs.x86_64',
        'quota-nls.noarch',
        'quota.x86_64',
        'rasdaemon.x86_64',
        'readline.x86_64',
        'rootfiles.noarch',
        'rpcbind.x86_64',
        'rpm-build-libs.x86_64',
        'rpm-libs.x86_64',
        'rpm-python.x86_64',
        'rpm.x86_64',
        'rsync.x86_64',
        'rsyslog.x86_64',
        'samba-libs.x86_64',
        'screen.x86_64',
        'security-tool.x86_64',
        'sed.x86_64',
        'setup.noarch',
        'shadow-utils.x86_64',
        'smartmontools.x86_64',
        'sqlite.x86_64',
        'squashfs-tools.x86_64',
        'sysfsutils.x86_64',
        'syslinux.x86_64',
        'sysmonitor-kmod.x86_64',
        'sysstat.x86_64',
        'systemd-libs.x86_64',
        'systemd-sysv.x86_64',
        'systemd.x86_64',
        'sysvinit-tools.x86_64',
        'tar.x86_64',
        'tcp_wrappers-libs.x86_64',
        'tcp_wrappers.x86_64',
        'teamd.x86_64',
        'tuned.noarch',
        'tzdata.noarch',
        'unzip.x86_64',
        'ustr.x86_64',
        'util-linux.x86_64',
        'vim-common.x86_64',
        'vim-enhanced.x86_64',
        'vim-filesystem.x86_64',
        'vim-minimal.x86_64',
        'virt-what.x86_64',
        'wget.x86_64',
        'which.x86_64',
        'xfsprogs.x86_64',
        'xz-libs.x86_64',
        'xz.x86_64',
        'yum-metadata-parser.x86_64',
        'yum.noarch',
        'yum-plugin-priorities.noarch',
        'zip.x86_64',
        'zlib.x86_64',
        'dosfstools.x86_64',
        'chrony.x86_64',
        'grub2-efi-x64',
        'grub2-efi-x64-cdboot',
        'efibootmgr',
        'efivar',
        'shim-unsigned-x64.x86_64',
        'shim-x64.x86_64',
        'selinux-policy-targeted',
        'euleros-lsb.x86_64',
        'nfs-utils.x86_64',
        'cifs-utils.x86_64',
        'libtool-ltdl.x86_64',
        'ipvsadm.x86_64',
        'keepalived.x86_64 ',
        'iptables-devel.i686',
        'iptables-devel.x86_64',
        'iptables-services.x86_64',
        'iptables-services.i686',
        'sg3_utils.x86_64',
        'bc.x86_64',
        'haveged.x86_64',
        'tcl.x86_64',
        'libselinux-python.x86_64',
        'librados2.x86_64',
        'device-mapper-multipath.x86_64',
        'device-mapper-multipath-libs.x86_64',
        'boost-thread.x86_64',
        'boost-system.x86_64',
        'i40e.x86_64',
        'ndsend.x86_64',
        'traceroute.x86_64',
        'libnl.x86_64',
        'kmod-megaraid_sas',
        'patch.x86_64',
        'kernel-headers.x86_64',
        'authselect.x86_64',
        'network-scripts.x86_64',
        'network-scripts-teamd.x86_64',
        'open-iscsi.x86_64',
        'python3-unversioned-command.x86_64',
        'sudo-1.8.27-5.h9.eulerosv2r9.x86_64',
    ]
}
PRE_SCRIPT_RAID = '''
#!/bin/sh
#加载额外驱动
driver_list=(
    "hinic3"
    "hisdk3"
    "hiudk3"
    "hiraid"
    "sssraid"
)

for driver in "${driver_list[@]}"; do
    ko_path=$(find /usr/lib -type f -name "${driver}*" | head -n 1)
    insmod "${ko_path}" && depmod
    modinfo "${driver}" >> /tmp/preinstall.log  2>&1
    if [ $? -ne 0 ]; then
        echo "insmod ${driver} failed!! skip."
    fi
done
vg_name=VolGroup2
vg_base_name=$vg_name
vgdisplay | grep -w $vg_name > /dev/null 2>&1
if [[ $? == 0 ]]
then
    i=3
    while(true)
    do
        vg_name="$vg_base_name$i"
        vgdisplay | grep -w $vg_name > /dev/null 2>&1
        if [[ $? != 0 ]]
        then
            break
        fi
        ((i=i+1))
    done
fi
sys_disk_name=`fdisk -l | grep Disk | grep -wE 'GB|GiB|TiB|TB' | awk -F '/' '{print $3}' | awk -F ':' '{print $1}' | grep -v mapper | grep -vi nvme | grep -v loop | sort | sed -n '1p'`
    echo "#System bootloader configuration" >  /tmp/part-include
    echo "bootloader --append=\"crashkernel=auto\" --location=mbr --driveorder=$sys_disk_name --iscrypted --password={GRUB_PASSWD}" >> /tmp/part-include
    echo "#partitioning scheme generated in %pre for sysdisk" >> /tmp/part-include
echo "zerombr" >> /tmp/part-include
    echo "ignoredisk --only-use=$sys_disk_name"  >> /tmp/part-include
echo "clearpart --all --drives=$sys_disk_name " >> /tmp/part-include
echo "part /boot --fstype=\"ext4\" --ondisk=$sys_disk_name --size=512" >> /tmp/part-include
echo "part /boot/efi --fstype=\"efi\" --ondisk=$sys_disk_name --size=1024 --fsoptions=\"umask=0077,shortname=winnt\"" >> /tmp/part-include
echo "part swap --fstype=\"swap\" --ondisk=$sys_disk_name --size=8192" >> /tmp/part-include
echo "part pv.1100 --fstype=\"lvmpv\" --ondisk=$sys_disk_name --size=1 --grow" >> /tmp/part-include
echo "volgroup $vg_name --pesize=4096 pv.1100" >> /tmp/part-include
echo "logvol /var  --fstype=\"ext4\" --percent=30 --name=var --vgname=$vg_name" >> /tmp/part-include
echo "logvol /tmp  --fstype=\"ext4\" --percent=4 --name=tmp --vgname=$vg_name" >> /tmp/part-include
echo "logvol /opt  --fstype=\"ext4\" --percent=50 --name=opt --vgname=$vg_name" >> /tmp/part-include
echo "logvol /home  --fstype=\"ext4\" --percent=4 --name=home --vgname=$vg_name" >> /tmp/part-include
echo "logvol /usr  --fstype=\"ext4\" --percent=4 --name=usr --vgname=$vg_name" >> /tmp/part-include
echo "logvol /  --fstype=\"ext4\" --percent=8 --name=root --vgname=$vg_name"  >> /tmp/part-include
'''
POST_SCRIPT_X86 = '''
# make /etc/rc.d/rc.local executable
chmod +x /etc/rc.d/rc.local
#service sshd open root
/usr/bin/sed -i '/PermitRootLogin/s/no/yes/' /etc/euleros_security/security.conf
# Resolving the CVE-2021-4034 Vulnerability
chmod 0755 /usr/bin/pkexec
/usr/bin/sed -i '/ALWAYS_SET_PATH/s/yes/no/' /etc/euleros_security/security.conf
#disable euler origin harden
/usr/bin/sed -i 's/^SELINUX=.*$/SELINUX=disabled/g' /etc/selinux/config
#delete useless ntp server
/usr/bin/sed -i '/^server.*$/d' /etc/ntp.conf
#set kernal parameters to disable rename nic name and make sure it will not be remove from grub.cfg file
#avoid losing config when eulerOS reset kernal parameter
#protect /tmp/upgrade/ from deleting
sed -i '/\/tmp\/upgrade/d' /usr/lib/tmpfiles.d/tmp.conf
echo 'x /tmp/upgrade' >> /usr/lib/tmpfiles.d/tmp.conf
#fix euler file bug(do not executed because bug is fixed)
    l_num=`grep -n "root" /etc/sudoers | grep ALL | awk -F ':' '{printf $1}'`
    sed -i "$l_num iALL     ALL=(ALL)       ALL" /etc/sudoers
    sed -i "$l_num iDefaults targetpw" /etc/sudoers
#let all users (not only users in wheel group) could operate 'su'
    sed -i '/auth.*required.*pam_wheel.so.*use_uid/d' /etc/pam.d/su
#make sure multipathd is stoped and disabled
chkconfig --level 35 multipathd off
systemctl disable multipathd.service
systemctl stop multipathd.service

#OS hardening: disable tribal-key function
rm -f /usr/lib/systemd/system/ctrl-alt-del.target
#OS hardening: delete compile tools
    rpm -e --nodeps make
rm -rf /usr/bin/readelf /usr/bin/lua /usr/bin/perl /usr/bin/rpcgen /usr/bin/ld /usr/bin/objdump


#set onboot to no for all port files except ifcfg-lo
/usr/bin/sed -i 's/ONBOOT=yes/ONBOOT=no/' /etc/sysconfig/network-scripts/ifcfg-*
/usr/bin/sed -i 's/ONBOOT=no/ONBOOT=yes/' /etc/sysconfig/network-scripts/ifcfg-lo

echo 'set enable-bracketed-paste off' >> /etc/inputrc

'''


class OSInfo:
    def __init__(self, project_id, grub_os25_passwd):
        self.grub_os25_passwd = grub_os25_passwd
        self.pre_script = PRE_SCRIPT_SOFT_RAID.replace('{GRUB_PASSWD}', self.grub_os25_passwd)
        if get_project_condition_boolean(project_id, 'eBackupServerARM'):
            self.cpu_arch = "ARM"
            os_template = self.get_os_file(
                "OceanStor_BCManager_EulerOS_ARM", "EulerOS_ARM.zip")
            self.post_script = POST_SCRIPT_ARM
            self.software_name = software_name_arm
        else:
            self.cpu_arch = "X86"
            os_template = self.get_os_file(
                "OceanStor_BCManager_EulerOS_X86", "EulerOS_X86.zip")
            self.post_script = POST_SCRIPT_X86
            self.software_name = software_name_x86
        self.os_file_name = os_template.replace(".iso", "")

    @staticmethod
    def get_os_file(os_file_name, os_zip_file_name):
        os_file_path, os_template = API.find_file(os_file_name, ".iso")
        if os_template == "":
            zippath, zipname = API.find_file(
                "OceanStor BCManager", os_zip_file_name)
            if zipname == "":
                raise HCCIException(
                    653066, "OceanStor BCManager..." + os_zip_file_name)
            file_path = os.path.join(zippath, zipname)
            ebackup_handle.check_compress_file([file_path])
            API.extract_file(file_path, "/home/pkg/")
            os_file_path, os_template = API.find_file(os_file_name, ".iso")
        logger.info("find " + os_file_name + " succ.")
        return os_template

    def is_hard_raid(self, bmc_ip_lower, bmc_name, bmc_passwd):
        ibm_obj = IBMCOperate(bmc_ip_lower, bmc_name, bmc_passwd)
        if ibm_obj.get_raid_controller_ids():
            self.pre_script = PRE_SCRIPT_RAID.replace('{GRUB_PASSWD}', self.grub_os25_passwd)


class InstallOS(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.params = ParamUtil()
        self.err_code = 0
        self.ebackup_db = BaseOps()
        self.__config_dict = self.params.get_service_cloud_param(pod_id, "eBackup")
        self.odk_api = None
        self.bmc_info = []
        self.description_cn = ""
        self.description_en = ""

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """

    def main_handle(self, pod_id):
        logger.info("start to install os.")
        self.odk_api = OdkApi(self.project_id, self.pod_id)
        logger.info("new odkapi succ.")
        self.bmc_info = self.ebackup_db.get_ebackup_install_info(pod_id)
        logger.info("get bmc info of ebackup node succ.")
        self.install_euleros()
        if self.err_code != 0:
            logger.error("install os failed.")
            if self.description_en == '':
                raise HCCIException(self.err_code)
            else:
                if self.description_cn != '':
                    raise HCCIException(self.err_code, (self.description_cn, self.description_en))
                else:
                    raise HCCIException(self.err_code, self.description_en)
        logger.info("install os end.")
        return Message(200)

    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            return self.main_handle(pod_id)
        except HCCIException as err:
            return Message(500, err.error_msg_cn, err.error_msg_en)
        except Exception as err:
            logger.error("install os failed:%s" % str(err))
            return Message(500, err, err)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def update_error_info(self, err, des_en, des_cn=''):
        if self.err_code == 0:
            self.err_code = err
            self.description_cn = des_cn
            self.description_en = des_en

    def install_euleros(self):
        device_lst, bmc_ip_sort_dict = self.get_info()
        logger.info("start to add device.")
        sn_lst = self.odk_api.addDevice(device_lst)
        logger.info("start to exec installOperatingSystem.")

        threados = threading.Thread(
            target=self.odk_api.installOperatingSystem,
            name=threading.current_thread().name,
            args=(sn_lst,))
        threados.start()
        thread_ping = threading.Thread(
            target=self.check_install_os_network,
            name=threading.current_thread().name,
            args=(
                [bmc_info["bmcIp"] for bmc_info in device_lst],
                bmc_ip_sort_dict,))
        thread_ping.start()

        self.check_result(
            [bmc_info["bmcIp"] for bmc_info in device_lst], bmc_ip_sort_dict)
        # 等待所有线程结束
        threados.join()
        thread_ping.join()

    def get_root_user(self):
        root_user = {}
        root_user['username'] = 'root'
        root_user['password'] = self.__config_dict['eBackup_os_root_password']
        return root_user

    def get_service_net_type(self):
        pro_dic = get_project_conditions(self.project_id)
        if 'ManageIPV6' in pro_dic:
            service_net_type = "IPV6"
        else:
            service_net_type = "IPV4"
        return service_net_type

    def get_info(self):
        grub_config = ReadConfig()
        grub_os25_passwd = grub_config.get_os_grub_passwd(
            'grub_euler25_password')
        grub_os29_passwd = grub_config.get_os_grub_passwd(
            'grub_euler29_password')
        device_lst = []
        root_user = self.get_root_user()
        service_net_type = self.get_service_net_type()
        bmc_info = OSInfo(self.project_id, grub_os25_passwd)
        bmc_ip_sort_dict = {}
        index = 0
        for sub_bmc_info in self.bmc_info:
            bmc_ip_lower = sub_bmc_info['bmc_ip'].lower()
            logger.info("install os for (%s) by odk." % bmc_ip_lower)
            business_ip = self.get_business_ip(
                index, sub_bmc_info, bmc_ip_lower)
            logger.info("get business ip info succ.")
            bmc_info.is_hard_raid(
                bmc_ip_lower,
                sub_bmc_info['bmc_name'],
                sub_bmc_info['bmc_passwd']
            )
            device_info = {
                "bmcIp": bmc_ip_lower,
                "bmcUser": sub_bmc_info['bmc_name'],
                "bmcPwd": sub_bmc_info['bmc_passwd'],
                "cpuArch": bmc_info.cpu_arch,
                "startMode": "UEFI",
                "osType": "EULER",
                "ipType": service_net_type,
                "serverType": sub_bmc_info['equipment_model'],
                "osTemplate": bmc_info.os_file_name,
                "rootUser": root_user,
                "businessGateway":
                    self.__config_dict['eBackup_externalom_gateway'],
                "businessIp": business_ip,
                "autoPartition": False,
                "postScripts": bmc_info.post_script,
                "preScripts": bmc_info.pre_script,
                "preInclude": ['/tmp/part-include'],
                "softwareNames": bmc_info.software_name,
                "addon": '''com_huawei_grub_safe --iscrypted --password='%s' ''' % grub_os29_passwd
            }
            device_lst.append(device_info)
            bmc_ip_sort_dict[bmc_ip_lower] = index
            index = index + 1
        return device_lst, bmc_ip_sort_dict

    def check_install_os_network(self, bmc_ip_list, bmc_ip_sort_dict):
        while True:
            time.sleep(120)
            result = self.odk_api.waitPingDevices(bmc_ip_list)
            if result['status'] == "false":
                break
            if result['data']:
                wait_ping_list = result['data']
                success_list, fail_list = \
                    self.ping_all_ip_to_end(wait_ping_list, bmc_ip_sort_dict)
                self.odk_api.updateEndStatus(success_list, fail_list)

    def ping_all_ip_to_end(self, bmc_ip_list, bmc_ip_sort_dict):
        success_ip_set = set()
        all_bmcip_set = set(bmc_ip_list)
        externalom_ip_lower = \
            self.__config_dict['datamover_externalom_iplist'].lower()
        external_om_iplist = externalom_ip_lower.split(',')
        num = 0
        while num < 60:
            success_bmcip_lst = []
            for server_ip in bmc_ip_list:
                idx = bmc_ip_sort_dict[server_ip]
                logger.info("begin to ping:" + external_om_iplist[idx])
                if ping(external_om_iplist[idx]):
                    success_bmcip_lst.append(server_ip)

            success_ip_set = success_ip_set | set(success_bmcip_lst)
            time.sleep(10)
            num = num + 1
            if len(success_ip_set) == len(bmc_ip_list):
                break
        fail_ip_set = all_bmcip_set - success_ip_set
        return list(success_ip_set), list(fail_ip_set)

    def check_result(self, bmc_ip_lst, bmc_ip_sort_dict):
        install_failed_lst = []
        while True:
            time.sleep(60)
            logger.info(
                "Waiting for installation result, bmcIp:%s", bmc_ip_lst)
            device_info_lst = self.ebackup_db.get_device(bmc_ip_lst)
            for device_info in device_info_lst:
                bmc_ip = device_info["bmcip"]
                exe_status = device_info.get("installstatus")
                logger.info(
                    "Device %s install_status: %s" % (bmc_ip, exe_status))
                if exe_status in INSTALL_STATUS_COMPLETED:
                    bmc_ip_lst.remove(bmc_ip)
                    if exe_status == INSTALL_STATUS_FAIL:
                        logger.info("Device %s install failed, failReason: %s"
                                    % (bmc_ip, device_info["failreason"]))
                        install_failed_lst.append(bmc_ip)

            if not bmc_ip_lst:
                break
            time.sleep(60)
        if install_failed_lst:
            externalom_ip_lower = \
                self.__config_dict['datamover_externalom_iplist'].lower()
            external_om_iplist = externalom_ip_lower.split(',')
            msg_cn = ""
            msg_en = ""
            for server_ip in install_failed_lst:
                idx = bmc_ip_sort_dict[server_ip]
                if msg_cn != "":
                    msg_cn = msg_cn + " | bmc ip:" + server_ip + \
                             ",不可达ip:" + external_om_iplist[idx]
                    msg_en = msg_en + " | bmc ip:" + server_ip + \
                             ",unreachable ip:" + external_om_iplist[idx]
                else:
                    msg_cn = "bmc ip:" + server_ip + ",不可达ip:" + \
                             external_om_iplist[idx]
                    msg_en = "bmc ip:" + server_ip + ",unreachable ip:" + \
                             external_om_iplist[idx]
            self.update_error_info(653041, msg_en, msg_cn)

    def get_business_ip(self, index, sub_bmc_info, bmc_ip):
        business_ip = self.get_management_ip_info(index, sub_bmc_info, bmc_ip)
        if self.__config_dict['storage_plane_mode'] == "lacp":
            ebk_storage_plane_mode = "4"
        else:
            ebk_storage_plane_mode = "1"

        if 'datamover_producestorage_iplist' in self.__config_dict and \
                self.__config_dict['datamover_producestorage_iplist'] != '':
            if sub_bmc_info.get('production_storage_plane', '') != '':
                pci_list, port_list = self.get_pci_and_slot(sub_bmc_info.get(
                    'production_storage_plane', ''), bmc_ip)
                producestorage_ip_lower = self.__config_dict[
                    'datamover_producestorage_iplist'].lower()
                producestorage_iplist = producestorage_ip_lower.split(',')
                producestorage_ip_info = {
                    "type": "bond",
                    "bond_mode": ebk_storage_plane_mode,
                    "ip_addr": producestorage_iplist[index],
                    "ip_mask":
                        self.__config_dict['datamover_producestorage_netmask'],
                    "gw": "",
                    "bond_name": "bond1",
                    "dev_port": ','.join(port_list),
                    "nic_pci": ','.join(pci_list)}
                business_ip.append(producestorage_ip_info)

        if 'datamover_backupstorage_iplist' in self.__config_dict and \
                self.__config_dict['datamover_backupstorage_iplist'] != '':
            pci_list, port_list = self.get_pci_and_slot(
                sub_bmc_info['backup_storage_plane'], bmc_ip)
            backupstorage_ip_lower = \
                self.__config_dict['datamover_backupstorage_iplist'].lower()
            backupstorage_iplist = backupstorage_ip_lower.split(',')
            backupstorage_ip_info = {
                "type": "bond",
                "bond_mode": ebk_storage_plane_mode,
                "ip_addr": backupstorage_iplist[index],
                "ip_mask": self.__config_dict[
                    'datamover_backupstorage_netmask'],
                "gw": self.__config_dict[
                    'datamover_backupstorage_gateway'
                ].lower(),
                "bond_name": "bond2",
                "dev_port": ','.join(port_list),
                "nic_pci": ','.join(pci_list)}
            business_ip.append(backupstorage_ip_info)
        return business_ip

    def get_management_ip_info(self, index, sub_bmc_info, bmc_ip):
        business_ip = []

        if self.__config_dict['management_plane_mode'] == "lacp":
            ebk_manage_plane_mode = "4"
        else:
            ebk_manage_plane_mode = "1"

        pci_list, port_list = \
            self.get_pci_and_slot(sub_bmc_info['management_plane'], bmc_ip)
        management_ip_info = {
            "type": "bond",
            "bond_mode": ebk_manage_plane_mode,
            "bond_name": "bond0",
            "dev_port": ','.join(port_list),
            "nic_pci": ','.join(pci_list)}
        business_ip.append(management_ip_info)

        externalom_ip_lower = \
            self.__config_dict['datamover_externalom_iplist'].lower()
        external_om_iplist = externalom_ip_lower.split(',')
        management_ip_info = {
            "type": "vlan_bond",
            "ip_addr": external_om_iplist[index],
            "ip_mask": self.__config_dict['eBackup_externalom_netmask'],
            "gw": self.__config_dict['eBackup_externalom_gateway'],
            "bond_name": "bond0",
            "vlan_id": self.__config_dict['eBackup_externalom_tag']}
        business_ip.append(management_ip_info)
        return business_ip

    def get_pci_and_slot(self, slot_map, bmc_ip):
        pci_list = []
        port_list = []

        slot_map_list = slot_map.split(",") if slot_map else []
        for slot in slot_map_list:
            pci, port_id = network_pci_slot_mapping_util.NicPciCls. \
                get_nic_pci_and_pid_by_slot_from_conf(bmc_ip, slot)
            pci_list.append(pci)
            port_list.append(port_id)
        return pci_list, port_list

        # the code has been updated to python3.7
