#!/bin/bash
new_version=$1
source /opt/huawei-data-protection/ebackup/sbin/log.sh

function check_parameter() {
    PARA=$1
    echo "${PARA}" | xargs echo -n | grep -E "[%]|[@]|[$]|[?]|[&]|[#]|[~]|[!]|[|]|[<]|[>]|[;]|[\`]|[\\]|[\"]|[']|[(]|[)]|[{]|[}]|[[]|[]]|[\^]|[']|[\*]|(\.\.)" 1>/dev/null 2>&1
    if [ $? -eq 0 ]; then
        log_error "[stop_service_force(),$LINENO]The version input is invalid"
        return 1
    fi
    return 0
}

function stop_service_force()
{
    log_info "[stop_service_force(),$LINENO]Begin to stop service force."
    service hcp stop force >/dev/null 2>&1
    if [ $? -eq 0 ];then
        log_info "[stop_service_force(),$LINENO]Stop service force success by command."
        return 0
    fi
    log_info "[stop_service_force(),$LINENO]Stop service force failed by command,now try to kill process force."
    if [ -f "/etc/SuSE-release" ];then
        local crontab_path="/var/spool/cron/tabs/root"
    else
        local crontab_path="/var/spool/cron/root"
    fi

    grep "hcp_pm_crontab_chk.sh" $crontab_path >/dev/null 2>&1
    if [ $? -eq 0 ];then
        sed -i "/hcp_pm_crontab_chk.sh/ d" ${crontab_path} >/dev/null 2>&1 || sed -i "/hcp_pm_crontab_chk.sh/ d" ${crontab_path} >/dev/null 2>&1
        grep "hcp_pm_crontab_chk.sh" ${crontab_path} >/dev/null 2>&1
        if [ $? -eq 0 ];then
            log_error "[stop_service_force(),$LINENO]Romove monitor script failed." 
            return 1
        fi

        if [ -f "/etc/SuSE-release" ];then
            sleep 3
            /sbin/service cron restart >/dev/null 2>&1
        else
            sleep 3
            systemctl restart crond >/dev/null 2>&1
        fi
    fi

    local ebackup_pids=`ps -ef | grep -i ebackup | grep  -v 'grep' | awk -F " " '{print $2}'`
    for pid in $ebackup_pids
    do
        kill -9 $pid
    done
    log_info "[stop_service_force(),$LINENO]Begin to stop gaussdb."
    sh /opt/huawei-data-protection/ebackup/bin/gaussdb_sandbox.sh stop

    ps -ef | grep -i ebackup | grep -v 'grep' | grep -i ebackup >/dev/null 2>&1
    if [ $? -eq 0 ];then
        log_error "[stop_service_force(),$LINENO]Stop service force failed by killing  process force." 
        return 1
    fi

    sh /opt/huawei-data-protection/ebackup/bin/gaussdb_sandbox.sh status | grep "server is running" >/dev/null
    if [ $? -eq 0 ];then
        log_error "[stop_service_force(),$LINENO]Stop gaussdb failed." 
        return 1
    fi
    log_info "[stop_service_force(),$LINENO]Stop service force success by killing  process force."
    return 0
}

function start_service_force()
{
    service hcp start force >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_info "[start_service_force(),$LINENO]Start service force failed."
        return 1
    fi
    return 0
}


echo "step0: check version"
if [ -z "$new_version" ];then
    echo "please input version"
    exit 1
fi
check_parameter "$new_version"
if [ $? -ne 0 ];then
   echo "check version failed."
   exit 1
fi

echo "Step1: stop service force."
stop_service_force
if [ $? -ne 0 ];then
   echo "Stop service force failed."
   exit 1 
fi

echo "Step2: rollback self force."
if [ -f "/tmp/upgrade/upgrade_pkg/upgrade/upgrade_tool.sh" ]; then
    sed -i "/System Version=/ c System Version=$new_version" /opt/huawei-data-protection/ebackup/conf/versions.conf
    sh /tmp/upgrade/upgrade_pkg/upgrade/upgrade_tool.sh rollback_self
    if [ $? -ne 0 ];then
        echo "rollback self failed."
        exit 1
    fi
else
    echo "upgrade_tool is not exist"
    exit 1
fi

echo "Step3: start service force."
start_service_force
if [ $? -ne 0 ];then
   echo "rollback self failed."
   exit 1 
fi

echo "Rollback and start force successfully."
exit 0