# -*- coding:utf-8 -*-
import os

HTTP_STATUS_OK = [200, 201, 204]

ADAPTATION_PKG_UPLOAD_SUCCESS_STATUS = 1
MO_EXCEPT_CODE = "404"
VERSION_MAP = \
    {
        "6.5.1": "8.0.1",
        "8.0.2": "8.0.6.SPC200",
        "8.0.3": "8.1.0",
        "8.1.0": "8.2.0",
        "8.1.1": "8.2.0.SPC300",
        "8.2.0": "8.3.0",
        "8.2.1": "8.3.1",
        "8.3.0": "8.5.0",
    }

SFS_CERT_TYPE = "SFS"
NOVA_CERT_TYPE = "NOVA"
MO_CERT_TYPE = "MO"


class Action(object):
    INSTALL_SERVER = "Install"
    CONFIG_ONE_A_THREE_S = "configOneAThreeS"
    UPGRADE_SERVER = "Upgrade"
    START_SERVER = "Start Service"
    STOP_SERVER = "Stop Service"
    REGISTER_OM_DNS = "OM Domain Config"
    REGISTER_DNS = "Domain Config"
    REMOVE_API = "Remove Api"
    REGISTER_API = "Register Api"
    UPDATE_NGINX = "Update Configuration"


class Capacity(object):
    BYTES = 1
    BYTES_S = "B"
    KB = 1024
    KB_S = "KB"
    MB = 1024 * 1024
    MB_S = "MB"
    GB = 1024 * 1024 * 1024
    GB_S = "GB"
    ONE_THOUSAND = 1024


class Component(object):
    REPLICATION = "eReplication"
    CSDR_U = "CSDR"
    CSHA_U = "CSHA"
    VHA_U = "VHA"
    CSDR_L = CSDR_U.lower()
    CSHA_L = CSHA_U.lower()
    VHA_L = VHA_U.lower()
    SDR = "SDR"
    APIG = "API_Gateway"
    OPENSTACK = "OpenStack"
    MANAGE_ONE = "ManageOne"
    NGINX = "Nginx"
    NGINX_L = "nginx"


class PatchOperation(object):
    UPLOAD = "upload"
    INSTALL = "install"
    ROLLBACK = "rollback"


class Euler(object):
    LIMIT_VERSION = 2
    LIMIT_ARM_RELEASE = 8
    LIMIT_X86_RELEASE = 9


class EulerUpgrade(object):
    LATEST_VERSION = "5.10.0-60.18.0.50.h966.eulerosv2r11"
    SUPPORT_VERSION = ["eulerosv2r7", "eulerosv2r11"]


class Example(object):
    CSDR_MAP = "region1_id,az1_id,az1_business_volume_type|" \
               "region2_id,az2_id,az2_business_volume_type"
    CSDR_MAP_FOR_NAS = "region1_id,az1_id,share_type1|" \
                       "region2_id,az2_id,share_type2"
    CSDR_MAP_CYCLE = "region1_id,az1_id,az1_business_volume_type|" \
                     "region2_id,az2_id,az2_business_volume_type_1&1#" \
                     "region1_id,az1_id,az1_business_volume_type|" \
                     "region2_id,az2_id,az2_business_volume_type_2&2"
    CSDR_MAP_CYCLE_FOR_NAS = \
        "region1_id,az1_id,share_type1|region2_id,az2_id,share_type2" \
        "#region1_id,az1_id,share_type3|region2_id,az2_id,share_type4"
    CSHA_MAP = "az1.dc1,volume_type1|az1.dc2,volume_type2"


class IPV(object):
    IPV4 = 4
    IPV6 = 6


class Network(object):
    OM = "external_om"
    PUBLIC = "Public_Service"


class Path(object):
    TMP_PATH = "/home/quorum_tmp"
    TMP_PATCH_PATH = "/home/patch_tmp"
    HOSTS_FILE = "/etc/hosts"
    QUORUM_INSTALL_PATH = "/opt/quorum_server"
    BCM_CERT_SOURCE_PATH = "/opt/BCManager/Runtime/LegoRuntime/certs"
    BCM_CERT_DEST_PATH = "/home/DRManager/certs"
    LOCAL_TEMP_PATH = os.path.join(os.path.dirname(os.path.dirname(__file__)), "LocalTempPath")
    NODE_TMP_PATH = "/home/DRManager/tmp"
    SYS_IPTABLES_PATH = "/etc/sysconfig/iptables"
    BCM_SCRIPTS_PATH = "/opt/BCManager/Runtime/bin/"
    BCM_ROOT_SCRIPTS_PATH = "/opt/BCManager/Runtime/root_tools/"
    CIPHER_BACKUP_PATH = "/opt/BCManager/Runtime/backup/changeEncryptBackup"
    LEGO_FILE_PATH = "/opt/BCManager/Runtime/LegoRuntime/conf/lego.properties"
    LEGO_DEPLOY_FILE_PATH = "/opt/BCManager/Runtime/LegoRuntime/conf/legoDeploy.conf"
    SYS_OS_FILE = "/etc/libuser.conf"
    NODE_PROPERTIES_PATH = "/opt/BCManager/Runtime/LegoRuntime/conf/node.properties"
    NODE_AGENT_PROPERTIES_PATH = "/opt/BCManager/Runtime/NodeAgent/conf/nodeAgent.properties"
    RD_INSTALLED_PATH = "/opt/BCManager/Runtime/bin/RDInstalled.xml"
    TOMCAT_WEB_XML_PATH = "/opt/BCManager/Runtime/Tomcat6/Lego-UI-Plat/WEB-INF/web.xml"
    TOMCAT_SERVER_XML_PATH = "/opt/BCManager/Runtime/Tomcat6/conf/server.xml"
    NGINX_SERVER_CONF_PATH = "/opt/BCManager/Runtime/nginx/conf/nginx.conf"
    HA_COM_XML_PATH = "/opt/BCManager/Runtime/ha/module/hacom/conf/hacom.xml"
    HA_SYN_XML_PATH = "/opt/BCManager/Runtime/ha/module/hasync/conf/hasync.xml"
    JRE_PATH = "/opt/BCManager/Runtime/jre6.0.18/bin/"
    KEYSTORE_FILE_PATH = "/opt/BCManager/Runtime/LegoRuntime/certs/bcm.keystore"
    DR_USER_PATH = "/home/DRManager"
    BCM_DATA_BACKUP_PATH = "/home/DRManager/FCDConfigData.zip"
    BCM_CERT_BACK_NAME = "trust.cert"
    DATA_BACKUP_PATH = "/home/DRManager/.FCU_AUTO_BACK"
    MIGRATE_DATA_BACKUP_PATH = "/home/DRManager/.MIGRATE_DATA_BACK"
    BACKUP_DATA_FILE_NAME = "FCDConfigData.zip"
    INSTALL_FILE_NAME = "RDInstalled.xml"
    INSTALL_FILE_SRC = "/home/ICUser/RDInstalled.xml"
    RUNTIME_BACK_PATH = "Runtime_Bak"
    GAUSSDB_PATH = "/usr/local/gaussdb"
    GAUSSDB_BACK_PATH = "gaussdb_bak"
    GAUSSDB_DATA_PATH = "/opt/gs/app/data"
    GAUSSDB_DATA_BACK_PATH = "gaussdb_data_bak"
    SYS_SUDO_CONFIG_PATH = "/etc/sudoers"
    SYS_SUDO_DIR_PATH = "/etc/sudoers.d"
    BACKUP_SUDO_CONFIG_NAME = "sudo_config"
    BACKUP_SUDO_DIR_NAME = "sudo_dir"
    UPGRADE_TEMP_PATH = "/var/eReplication"
    CPS_NOVA_CERT_FILE = "/etc/FSSecurity/server-cert/nova_ca.crt"
    TEMP_NOVA_CERT_FILE = "/home/fsp/nova_ca.crt"
    NOVA_CERT_NAME = "nova_ca.crt"
    DR_TEMP_CONF_DEST_PATH = "/home/DRManager/tmpProperties"
    EXPORT_CERT_PATH = "/opt/.HCCI_EXPORT_CERTS"
    SYNC_FILE_FLAG = "transferDone.flag"
    TMP_BACKUP_FILE_NAME = "backup.tar.gz"
    NODE_ROOT_PATH = "/root"
    EULER_UPGRADE_PATH = "/var/euler_upgrade"
    ISO_PKG_PATH = f"{EULER_UPGRADE_PATH}/pkg"
    ISO_UPGRADE_PATH = f"{EULER_UPGRADE_PATH}/upgrade"
    BAK_TEMP_PATH = "/os_upgrade"
    OS_BAK_PATH = f"{BAK_TEMP_PATH}/.osbak"
    LOGIC_VOLUME_PATH = "/dev/euleros/osbak"
    SHOWSYS_CMD_FILE = "showsys"
    USR_SBIN_DIR = "/usr/sbin"


class Pkg(object):
    PKG_RE_ARM = r"^OceanStor BCManager (.*)_KVMtemplate_Euler_ARM.zip$"
    PKG_RE_X86 = r"^OceanStor BCManager (.*)_KVMtemplate_Euler_X86.zip$"
    PATCH_PKG_RE = r"^OceanStor BCManager (.*)_eReplication_for_Euler\.zip$"
    CONSOLE_PKG_RE = r"^OceanStor BCManager (.*)_eReplication_Console.zip$"
    ADAPTATION_PKG_REG = "^resource_10UnifiedAccess2MO_eReplication_(.*)\\.tar\\.gz$"
    CONSOLE_RELEASE_RE = r"^CSDRConsole-(.*)-release.tar.gz$"
    SERVER_PKG_PREFIX = "OceanStor BCManager"
    SERVER_PKG_SUFFIX = "eReplication_DMK.zip"
    PATCH_PKG_SUFFIX = "eReplication_for_Euler.zip"
    OS_RE_ARM = r"^OceanStor(.*)Euler_ARM.qcow2$"
    OS_RE_X86 = r"^OceanStor(.*)Euler_X86.qcow2$"
    QUORUM_RE_ARM = r"^OceanStor(.*)QuorumServer(.*?)(?<!_X86_64)\.zip$"
    QUORUM_RE_X86 = r"^OceanStor(.*)QuorumServer(.*?)(?<!_ARM_64)\.zip$"
    QUORUM_FLAG = "QuorumServer"
    SERVER_TEMP_NAME = "eReplication_Server_KVM.qcow2"
    QUORUM_TEMP_NAME = "eReplication_quorum_KVM.qcow2"
    IMAGE_NAME = "eReplication_image"
    QUORUM_EXTRACT_PATH = "eReplication_quorum"
    SERVER_EXTRACT_PATH = "eReplication_Server"
    UPGRADE_OS_PKG_SUFFIX_ARM = "EulerOS_ARM.zip"
    UPGRADE_OS_PKG_SUFFIX_X86 = "EulerOS_X86.zip"
    SERVER_PKG_SIZE_LIMIT = 2
    SERVER_PKG_FILE_LIMIT = 20
    CONSOLE_PKG_SIZE_LIMIT = 50
    CONSOLE_PKG_FILE_LIMIT = 15
    # 最大解压文件限定为5GB
    UPGRADE_OS_PKG_SIZE_LIMIT = 1024 * 1024 * 1024 * 5
    # 最大文件数量限定10万个
    UPGRADE_OS_PKG_FILE_COUNT = 1 * 1000 * 100


class OS(object):
    VALID_STATE_LIST = ["PRE_UPGRADING", "UPGRADING", "POST_UPGRADING", "PRE_CHECKING", "ROLLBACKING"]
    UPGRADE_PRECENT_MAP = {
        "PRE_UPGRADING": "10%",
        "UPGRADING": "20%",
        "POST_UPGRADING": "80%",
        "REBOOTING": "90%",
        "SUCCESS": "100%",
        "SKIP": "100%"
    }
    # 卷组空闲容量要求>8.4G
    VG_FREE_SIZE = 8.4


class VMName(object):
    VM_NAME_01 = "Service-eReplication01"
    VM_NAME_02 = "Service-eReplication02"
    VM_NAME_PREFIX = "Service-eReplication"
    SERVICE_NAME = "Service"
    QUORUM_NAME = "Quorum"
    GROUP_NAME = "eReplication"
    MEW_GROUP_NAME = "eReplication_8u16g_"


class VMScale(object):
    CPU_0 = 0
    CPU_2 = 2
    CPU_4 = 4
    CPU_8 = 8
    RAM_0 = 0
    RAM_4 = 4
    RAM_8 = 8
    RAM_16 = 16
    DISK_0 = 0
    DISK_20 = 20
    DISK_40 = 40


class CSDRSilvanInfos(object):
    def __init__(self, region_id, console_home):
        self.region_id = region_id
        self.console_home = console_home
        self.__byte_to_gb = 1073741824
        self.__endpoint_infos()
        self.__links_infos()
        self.__product_infos()
        self.__product_action_infos()
        self.__quota_indicators_infos()
        self.__meter_metrics_infos()

    def __endpoint_infos(self):
        self.zh_endpoint_infos = \
            {'id': 'csdr', 'name': '云服务器容灾', 'shortName': 'CSDR',
             'description':
                 '云服务器容灾服务为弹性云服务器和裸金属服务器提供异地容灾保护。'
                 '当生产中心发生灾难时，可在异地灾备中心恢复受保护的弹性云服务器。'
                 '此外，弹性云服务器和裸金属服务器还可以配置本地存储双活保护，'
                 '当生产中心单套存储设备发生故障时，数据零丢失，业务不中断。',
             'serviceCss': 'csdr', 'defaultOpen': True, 'domainType': 'HVS',
             'nonsupportRegions': '', 'locale': 'zh-cn',
             'endpointScope': 'global', 'active': True,
             'catalogCss': 'Storage', 'catalogId': 2, 'version': 'v1.0',
             'endpoint':
                 f'https://{self.console_home}/csdr/#/main/csdrInstanceList',
             'serviceOrder': 30, "deployMode": "global"}
        self.en_endpoint_infos = \
            {'id': 'csdr', 'name': 'Cloud Server Disaster Recovery',
             'shortName': 'CSDR',
             'description':
                 'Cloud Server Disaster Recovery (CSDR) provides '
                 'remote disaster recovery protection for Elastic Cloud '
                 'Servers (ECSs) and Bare Metal Servers (BMSs). Once the '
                 'production center encounters a disaster, ECSs and BMSs '
                 'protected by CSDR can be restored in the remote DR center.'
                 'In addition, ECSs and BMSs can be configured with '
                 'active-active local storage to further guarantee zero '
                 'data loss and service stoppage.',
             'serviceCss': 'csdr', 'defaultOpen': True, 'domainType': 'HVS',
             'nonsupportRegions': '', 'locale': 'en-us',
             'endpointScope': 'global', 'active': True,
             'catalogCss': 'Storage', 'catalogId': 2, 'version': 'v1.0',
             'endpoint':
                 f'https://{self.console_home}/csdr/#/main/csdrInstanceList',
             'serviceOrder': 30, "deployMode": "global"}

    def __links_infos(self):
        create = \
            f"https://{self.console_home}/csdr/#/main/csdrInstanceApply"
        instance = \
            f"https://{self.console_home}/csdr/#/main/csdrInstanceList"
        modify = \
            f"https://{self.console_home}/csdr/#/main/csdrInstanceApply"
        self.links_infos = (
            ("apply_url_csdr", "buy", "apply", create, "product"),
            ("instance_url_csdr", "detail", "apply", instance, "endpoint"),
            ("apply_url_csdr", "buy", "apply", modify, "order"))

    def __product_infos(self):
        self.product_infos = \
            {
                "proNameZh": "云服务器容灾",
                "proNameEn": "Cloud Server Disaster Recovery",
                "serviceId": "csdr", "iconId": "csdr",
                "serviceParams": "serviceParams",
                "proDesZh":
                    "云服务器容灾服务为弹性云服务器和裸金属服务器提供异地容灾保护。"
                    "当生产中心发生灾难时，可在异地灾备中心恢复受保护的弹性云服务器。"
                    "此外，弹性云服务器和裸金属服务器还可以配置本地存储双活保护，"
                    "当生产中心单套存储设备发生故障时，数据零丢失，业务不中断。",
                "proDesEn":
                    "Cloud Server Disaster Recovery (CSDR) provides "
                    "remote disaster recovery protection for Elastic Cloud "
                    "Servers (ECSs) and Bare Metal Servers (BMSs). Once the "
                    "production center encounters a disaster, ECSs and BMSs "
                    "protected by CSDR can be restored in the remote DR "
                    "center.In addition, ECSs and BMSs can be configured "
                    "with active-active local storage to further guarantee "
                    "zero data loss and service stoppage.",
                "catalogId": "2", "isDefault": "true"
            }

    def __product_action_infos(self):
        self.product_action_infos = [
            {
                "service_type": "csdr",
                "action": "apply"
            },
            {
                "service_type": "csdr",
                "action": "modify"
            },
            {
                "service_type": "csdr",
                "action": "delete"
            }
        ]

    def __quota_indicators_infos(self):
        self.quota_indicators_infos = \
            {
                "quota_indicators": {
                    "region_id": self.region_id,
                    "cloud_infra_type": "FUSION_CLOUD",
                    "availability_zone_id": "", "indicators": [
                        {
                            "name": "csdr.vol.num",
                            "display_name":
                                '{"en_us":"Number of volumes/file systems on the DR host",'
                                '"zh_cn":"容灾主机卷/文件系统个数"}',
                            "unit": '{"en_us":"","zh_cn":"个"}',
                            "data_type": "1", "order_no": 180, "min": 0,
                            "max": 262144, "capacity": 0,
                            "endpoint_id": "csdr",
                            "request_url": "", "response_template": "",
                        },
                        {
                            "name": "csdr.vol.size",
                            "display_name":
                                '{"en_us":"DR host volume/file system capacity",'
                                '"zh_cn":"容灾主机卷/文件系统容量"}',
                            "unit": '{"en_us":"GB","zh_cn":"GB"}',
                            "data_type": "1", "order_no": 181, "min": 0,
                            "max": 2147483647, "capacity": 0,
                            "endpoint_id": "csdr", "request_url": "",
                            "response_template": "",
                        },
                        {
                            "name": "csdr.instance.num",
                            "display_name":
                                '{"en_us":"Number of DR Instances",'
                                '"zh_cn":"容灾实例个数"}',
                            "unit": '{"en_us":"","zh_cn":"个"}',
                            "data_type": "1", "order_no": 182, "min": 0,
                            "max": 512, "capacity": 0, "endpoint_id": "csdr",
                            "request_url": "", "response_template": "",
                        }
                    ]
                }
            }

    def __meter_metrics_infos(self):
        self.meter_metrics_infos = {
            "metrics": [{
                "service_id": "csdr",
                "name": "csdr.vol.size",
                "display_name":
                    "{\"zh_CN\":\"容灾主机卷/文件系统容量\","
                    "\"en_US\":\"DR host volume/file system capacity\"}",
                "unit": "{\"zh_CN\":\"GB-小时\",\"en_US\":\"GB-Hour\"}",
                "region_id": self.region_id,
                "type": "interval",
                "cdr_parse_rule":
                    "data.split(\"|\")[14].trim().split(\",\")[1].trim()",
                "rate_parse_rule": "data.split(\"|\")[7].trim()",
                "cloud_service_type_code": "hws.service.type.csdr",
                "cloud_service_type_name":
                    "{\"zh_CN\":\"云服务器容灾卷/文件系统资源\","
                    "\"en_US\":\"CSDR volume/file system resources\"}",
                "resource_type_code": "hws.resource.type.csdr.vol",
                "resource_type_name":
                    "{\"zh_CN\":\"云服务器容灾卷/文件系统资源\","
                    "\"en_US\":\"CSDR volume/file system resources\"}",
                "cdr_folder_name": "csdr"
            }, {
                "service_id": "csdr",
                "name": "csdr.instance.num",
                "display_name":
                    "{\"zh_CN\":\"容灾实例个数\","
                    "\"en_US\":\"Number of DR Instances\"}",
                "unit": "{\"zh_CN\":\"个-小时\",\"en_US\":\"Number-Hour\"}",
                "region_id": self.region_id,
                "type": "interval",
                "cdr_parse_rule": "1",
                "rate_parse_rule": "data.split(\"|\")[7].trim()",
                "cloud_service_type_code": "hws.service.type.csdr",
                "cloud_service_type_name":
                    "{\"zh_CN\":\"云服务器容灾实例资源\","
                    "\"en_US\":\"Instance Resource of CSDR\"}",
                "resource_type_code": "hws.resource.type.csdr.ins",
                "resource_type_name":
                    "{\"zh_CN\":\"云服务器容灾实例资源\","
                    "\"en_US\":\"Instance Resource of CSDR\"}",
                "cdr_folder_name": "csdr"
            }]
        }


class CSHASilvanInfos(object):
    def __init__(self, region_id, console_home):
        self.region_id = region_id
        self.console_home = console_home
        self.__byte_to_gb = 1073741824
        self.__endpoint_infos()
        self.__links_infos()
        self.__product_infos()
        self.__product_action_infos()
        self.__quota_indicators_infos()
        self.__meter_metrics_infos()

    def __endpoint_infos(self):
        self.zh_endpoint_infos = \
            {'id': 'csha', 'name': '云服务器高可用', 'shortName': 'CSHA',
             'description':
                 '云服务器高可用服务为弹性云服务器提供同城数据中心间的高可用保护。'
                 '当生产中心发生灾难时，被保护的弹性云服务器能够自动或手动切换到灾备中心。',
             'serviceCss': 'csha', 'defaultOpen': True, 'domainType': 'HVS',
             'nonsupportRegions': '', 'locale': 'zh-cn',
             'endpointScope': 'global', 'active': True,
             'catalogCss': 'Storage', 'catalogId': 2, 'version': 'v1.0',
             'endpoint':
                 f'https://{self.console_home}/csha/#/main/cshaInstanceList',
             'serviceOrder': 30}
        self.en_endpoint_infos = \
            {'id': 'csha', 'name': 'Cloud Server High Availability',
             'shortName': 'CSHA',
             'description':
                 'Cloud Server High Availability (CSHA) provides HA '
                 'protection for Elastic Cloud Servers (ECSs) across data '
                 'centers in one city. When a disaster occurs in the '
                 'production center, the protected ECSs can be '
                 'automatically or manually switched to the DR center.',
             'serviceCss': 'csha', 'defaultOpen': True, 'domainType': 'HVS',
             'nonsupportRegions': '', 'locale': 'en-us',
             'endpointScope': 'global', 'active': True,
             'catalogCss': 'Storage', 'catalogId': 2, 'version': 'v1.0',
             'endpoint':
                 f'https://{self.console_home}/csha/#/main/cshaInstanceList',
             'serviceOrder': 30}

    def __links_infos(self):
        create = \
            f"https://{self.console_home}/csha/#/main/cshaInstanceApply"
        instance = \
            f"https://{self.console_home}/csha/#/main/cshaInstanceList"
        modify = \
            f"https://{self.console_home}/csha/#/main/cshaInstanceApply"
        self.links_infos = (
            ("apply_url_csha", "buy", "apply", create, "product"),
            ("instance_url_csha", "detail", "apply", instance, "endpoint"),
            ("apply_url_csha", "buy", "apply", modify, "order"))

    def __product_infos(self):
        self.product_infos = \
            {
                "proNameZh": "云服务器高可用",
                "proNameEn": "Cloud Server High Availability",
                "serviceId": "csha", "iconId": "csha",
                "serviceParams": "serviceParams",
                "proDesZh":
                    "云服务器高可用服务为弹性云服务器提供同城数据中心间的高可用保护。当生"
                    "产中心发生灾难时，被保护的弹性云服务器能够自动或手动切换到灾备中心",
                "proDesEn":
                    "Cloud Server High Availability (CSHA) provides HA "
                    "protection for Elastic Cloud Servers (ECSs) across "
                    "data centers in one city. When a disaster occurs in "
                    "the production center, the protected ECSs can be "
                    "automatically or manually switched to the DR center.",
                "catalogId": "2", "isDefault": "true"
            }

    def __product_action_infos(self):
        self.product_action_infos = [
            {
                "service_type": "csha",
                "action": "apply"
            },
            {
                "service_type": "csha",
                "action": "modify"
            },
            {
                "service_type": "csha",
                "action": "delete"
            }
        ]

    def __quota_indicators_infos(self):
        self.quota_indicators_infos = \
            {
                "quota_indicators": {
                    "region_id": self.region_id,
                    "cloud_infra_type": "FUSION_CLOUD",
                    "availability_zone_id": "", "indicators": [
                        {
                            "name": "csha.vol.num",
                            "display_name":
                                '{"en_us":"Number of HA Volumes",'
                                '"zh_cn":"高可用主机卷个数"}',
                            "unit": '{"en_us":"","zh_cn":"个"}',
                            "data_type": "1", "order_no": 170, "min": 0,
                            "max": 262144, "capacity": 0,
                            "endpoint_id": "csha",
                            "request_url": "", "response_template": "",
                        },
                        {
                            "name": "csha.vol.size",
                            "display_name":
                                '{"en_us":"Total Size of HA Volumes",'
                                '"zh_cn":"高可用主机卷容量"}',
                            "unit": '{"en_us":"GB","zh_cn":"GB"}',
                            "data_type": "1", "order_no": 171, "min": 0,
                            "max": 2147483647, "capacity": 0,
                            "endpoint_id": "csha", "request_url": "",
                            "response_template": "",
                        },
                        {
                            "name": "csha.instance.num",
                            "display_name":
                                '{"en_us":"Number of HA Instances",'
                                '"zh_cn":"高可用实例个数"}',
                            "unit": '{"en_us":"","zh_cn":"个"}',
                            "data_type": "1", "order_no": 172, "min": 0,
                            "max": 512, "capacity": 0, "endpoint_id": "csha",
                            "request_url": "", "response_template": "",
                        }
                    ]
                }
            }

    def __meter_metrics_infos(self):
        self.meter_metrics_infos = {
            "metrics": [{
                "service_id": "csha",
                "name": "csha.vol.size",
                "display_name":
                    "{\"zh_CN\":\"高可用主机卷容量\","
                    "\"en_US\":\"Total Size of HA Volumes\"}",
                "unit": "{\"zh_CN\":\"GB-小时\",\"en_US\":\"GB-Hour\"}",
                "region_id": self.region_id,
                "type": "interval",
                "cdr_parse_rule":
                    "data.split(\"|\")[14].trim().split(\",\")[1].trim()",
                "rate_parse_rule": "data.split(\"|\")[7].trim()",
                "cloud_service_type_code": "hws.service.type.csha",
                "cloud_service_type_name":
                    "{\"zh_CN\":\"云服务器高可用卷资源\","
                    "\"en_US\":\"Volume Resource of CSHA\"}",
                "resource_type_code": "hws.resource.type.csha.vol",
                "resource_type_name":
                    "{\"zh_CN\":\"云服务器高可用卷资源\","
                    "\"en_US\":\"Volume Resource of CSHA\"}",
                "cdr_folder_name": "csha"
            }, {
                "service_id": "csha",
                "name": "csha.instance.num",
                "display_name":
                    "{\"zh_CN\":\"高可用实例个数\","
                    "\"en_US\":\"Number of HA Instances\"}",
                "unit": "{\"zh_CN\":\"个-小时\",\"en_US\":\"Number-Hour\"}",
                "region_id": self.region_id,
                "type": "interval",
                "cdr_parse_rule": "1",
                "rate_parse_rule": "data.split(\"|\")[7].trim()",
                "cloud_service_type_code": "hws.service.type.csha",
                "cloud_service_type_name":
                    "{\"zh_CN\":\"云服务器高可用实例资源\","
                    "\"en_US\":\"Instance Resource of CSHA\"}",
                "resource_type_code": "hws.resource.type.csha.ins",
                "resource_type_name":
                    "{\"zh_CN\":\"云服务器高可用实例资源\","
                    "\"en_US\":\"Instance Resource of CSHA\"}",
                "cdr_folder_name": "csha"
            }]
        }


class VHASilvanInfos(object):
    def __init__(self, region_id, console_home):
        self.region_id = region_id
        self.console_home = console_home
        self.__byte_to_gb = 1073741824
        self.__endpoint_infos()
        self.__links_infos()
        self.__product_infos()
        self.__product_action_infos()
        self.__quota_indicators_infos()
        self.__meter_metrics_infos()

    def __endpoint_infos(self):
        self.zh_endpoint_infos = \
            {'id': 'vha', 'name': '云硬盘高可用', 'shortName': 'VHA',
             'description':
                 '云硬盘高可用服务为弹性云服务器和裸金属服务器中的云硬盘提供'
                 '本地存储双活保护。当单套存储设备发生故障时，数据零丢失，业务不中断。',
             'serviceCss': 'vha', 'defaultOpen': True, 'domainType': 'HVS',
             'nonsupportRegions': '', 'locale': 'zh-cn',
             'endpointScope': 'global', 'active': True,
             'catalogCss': 'Storage', 'catalogId': 2, 'version': 'v1.0',
             'endpoint':
                 f'https://{self.console_home}/vha/#/main/vhaInstanceList',
             'serviceOrder': 30}
        self.en_endpoint_infos = \
            {'id': 'vha', 'name': 'Volume High Availability',
             'shortName': 'VHA',
             'description':
                 'Volume High Availability Service provides '
                 'active-active local storage for volumes in the Elastic '
                 'Cloud Servers (ECSs) and Bare Metal Servers (BMSs). '
                 'When a storage device is faulty, no data is lost and '
                 'services are not interrupted.',
             'serviceCss': 'vha', 'defaultOpen': True, 'domainType': 'HVS',
             'nonsupportRegions': '', 'locale': 'en-us',
             'endpointScope': 'global', 'active': True,
             'catalogCss': 'Storage', 'catalogId': 2, 'version': 'v1.0',
             'endpoint':
                 f'https://{self.console_home}/vha/#/main/vhaInstanceList',
             'serviceOrder': 30}

    def __links_infos(self):
        create = \
            f"https://{self.console_home}/vha/#/main/vhaInstanceApply"
        instance = \
            f"https://{self.console_home}/vha/#/main/vhaInstanceList"
        modify = \
            f"https://{self.console_home}/vha/#/main/vhaInstanceApply"
        self.links_infos = (
            ("apply_url_vha", "buy", "apply", create, "product"),
            ("instance_url_vha", "detail", "apply", instance, "endpoint"),
            ("apply_url_vha", "buy", "apply", modify, "order"))

    def __product_infos(self):
        self.product_infos = \
            {
                "proNameZh": "云硬盘高可用",
                "proNameEn": "Volume High Availability",
                "serviceId": "vha", "iconId": "vha",
                "serviceParams": "serviceParams",
                "proDesZh":
                    "云硬盘高可用服务为弹性云服务器和裸金属服务器中的云硬盘提供"
                    "本地存储双活保护。当单套存储设备发生故障时，数据零丢失，业务不中断。",
                "proDesEn":
                    "Volume High Availability Service provides "
                    "active-active local storage for volumes in the Elastic "
                    "Cloud Servers (ECSs) and Bare Metal Servers (BMSs). "
                    "When a storage device is faulty, no data is lost and "
                    "services are not interrupted.",
                "catalogId": "2", "isDefault": "true"
            }

    def __product_action_infos(self):
        self.product_action_infos = [
            {
                "service_type": "vha",
                "action": "apply"
            },
            {
                "service_type": "vha",
                "action": "modify"
            },
            {
                "service_type": "vha",
                "action": "delete"
            }
        ]

    def __quota_indicators_infos(self):
        self.quota_indicators_infos = \
            {
                "quota_indicators": {
                    "region_id": self.region_id,
                    "cloud_infra_type": "FUSION_CLOUD",
                    "availability_zone_id": "", "indicators": [
                        {
                            "name": "vha.vol.num",
                            "display_name":
                                '{"en_us":"Number of VHA Volumes",'
                                '"zh_cn":"本地高可用卷个数"}',
                            "unit": '{"en_us":"","zh_cn":"个"}',
                            "data_type": "1", "order_no": 132, "min": 0,
                            "max": 262144, "capacity": 0,
                            "endpoint_id": "vha",
                            "request_url": "", "response_template": "",
                        },
                        {
                            "name": "vha.vol.size",
                            "display_name":
                                '{"en_us":"Total Size of VHA Volumes",'
                                '"zh_cn":"本地高可用卷容量"}',
                            "unit": '{"en_us":"GB","zh_cn":"GB"}',
                            "data_type": "1", "order_no": 132, "min": 0,
                            "max": 2147483647, "capacity": 0,
                            "endpoint_id": "vha", "request_url": "",
                            "response_template": "",
                        },
                        {
                            "name": "vha.instance.num",
                            "display_name":
                                '{"en_us":"Number of VHA Instances",'
                                '"zh_cn":"本地高可用实例个数"}',
                            "unit": '{"en_us":"","zh_cn":"个"}',
                            "data_type": "1", "order_no": 132, "min": 0,
                            "max": 512, "capacity": 0, "endpoint_id": "vha",
                            "request_url": "", "response_template": "",
                        }
                    ]
                }
            }

    def __meter_metrics_infos(self):
        self.meter_metrics_infos = {
            "metrics": [{
                "service_id": "vha",
                "name": "vha.vol.size",
                "display_name":
                    "{\"zh_CN\":\"硬盘高可用卷容量\","
                    "\"en_US\":\"Total Size of VHA Volumes\"}",
                "unit": "{\"zh_CN\":\"GB-小时\",\"en_US\":\"GB-Hour\"}",
                "region_id": self.region_id,
                "type": "interval",
                "cdr_parse_rule":
                    "data.split(\"|\")[14].trim().split(\",\")[1].trim()",
                "rate_parse_rule": "data.split(\"|\")[7].trim()",
                "cloud_service_type_code": "hws.service.type.vha",
                "cloud_service_type_name":
                    "{\"zh_CN\":\"云硬盘高可用卷资源\","
                    "\"en_US\":\"Volume Resource of VHA\"}",
                "resource_type_code": "hws.resource.type.vha.vol",
                "resource_type_name":
                    "{\"zh_CN\":\"云硬盘高可用卷资源\","
                    "\"en_US\":\"Volume Resource of VHA\"}",
                "cdr_folder_name": "vha"
            }, {
                "service_id": "vha",
                "name": "vha.instance.num",
                "display_name":
                    "{\"zh_CN\":\"硬盘高可用实例个数\","
                    "\"en_US\":\"Number of VHA Instances\"}",
                "unit": "{\"zh_CN\":\"个-小时\",\"en_US\":\"Number-Hour\"}",
                "region_id": self.region_id,
                "type": "interval",
                "cdr_parse_rule": "1",
                "rate_parse_rule": "data.split(\"|\")[7].trim()",
                "cloud_service_type_code": "hws.service.type.vha",
                "cloud_service_type_name":
                    "{\"zh_CN\":\"云硬盘高可用实例资源\","
                    "\"en_US\":\"Instance Resource of VHA\"}",
                "resource_type_code": "hws.resource.type.vha.ins",
                "resource_type_name":
                    "{\"zh_CN\":\"云硬盘高可用实例资源\","
                    "\"en_US\":\"Instance Resource of VHA\"}",
                "cdr_folder_name": "vha"
            }]
        }


class ArbInfo(object):
    ARB_IP = "csha_quorum_ip"
    ARB_USER_PWD = "csha_quorum_vm_sudo_password"


class Config(object):
    OS_CONFIG = "os_config"
    SKIP_OS_UPGRADE_IPS = "skip_os_upgrade_ips"
