#!/usr/bin/python3
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.business.service_monitor.service_monitor import ServiceMonitorCfg
from utils.business.service_monitor.service_monitor import ServiceNodeCfg
from utils.business.service_monitor.service_monitor import del_service_m_cfg
from utils.business.service_monitor.service_monitor import set_service_m_cfg

from plugins.eReplication.common.constant import Component


class API(object):

    @classmethod
    def delete_server_monitor_info(cls, pod_id, region_id):
        """
        删除十统一适配包的监控服务
        :param pod_id: 工程id
        :param region_id: regionId
        :return:
        """
        logger.info(f"Start to delete {region_id} server service monitor info.")
        service_monitor_cfg = ServiceMonitorCfg(
            Component.REPLICATION, "eReplication Server", region_id,
            Component.REPLICATION, "SAAS", None)
        result = del_service_m_cfg(pod_id, service_monitor_cfg)
        if not result:
            err_msg = "Delete server service monitor return False."
            logger.error(err_msg)
            raise Exception(err_msg)
        logger.info(f"Delete {region_id} server service monitor info success.")

    @classmethod
    def add_service_monitor_info(cls, pod_id, region_id, hosts):
        """
        注册十统一适配包的监控服务
        :param pod_id:
        :param region_id:
        :param hosts:
        :return:
        """
        logger.info(f"Start to add {region_id} server service monitor info.")
        node_info = []
        for host in hosts:
            for template_id in ['os_template', 'eReplication_service_template_id']:
                node_cfg = ServiceNodeCfg(host, template_id, "eReplication_log_id")
                node_info.append(node_cfg)
        monitor_cfg = ServiceMonitorCfg(
            Component.REPLICATION, "eReplication Server", region_id,
            Component.REPLICATION, "SAAS", node_info)
        result = set_service_m_cfg(pod_id, monitor_cfg)
        if not result:
            raise HCCIException("663609", "Set service monitor cfg return false")
        logger.info(f"Add {region_id} server service monitor info success.")
