# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.migrate_api import API as MIGRATE_API

logger.init("eReplication")


class RollbackData(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :return:
        """

        migrate_api = MIGRATE_API(self.project_id, self.pod_id, self.region_id)
        migrate_api.migrate_dr_service_data(rollback=True)
        migrate_api.clear_env()
