# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.upgrade_os_api import API as UPGRADE_OS_API
from plugins.eReplication.common.upgrade_api import API as UPGRADE_API

logger.init("eReplication RollbackOS")


class RollbackOS(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：os升级回退

        :param project_id:
        :param pod_id:
        :return:
        """
        UPGRADE_OS_API(self.project_id, self.pod_id, self.region_id).rollback_os()
        # 主动停止服务，处理虚拟机重启后触发的自动拉起
        logger.info("Start to stop all services.")
        UPGRADE_API(self.project_id, self.pod_id, self.region_id).stop_service()
