#!/usr/bin/python3
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import utils.common.log as logger
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.upgrade_api import API as UPGRADE_API

logger.init("DeleteServiceMonitor")


class DeleteServiceMonitor(BaseSubJob):
    """
        eReplication Server删除云服务监控配置
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        UPGRADE_API(self.project_id, self.pod_id, self.region_id).config_service_monitor()
