import utils.common.log as logger
from utils.common.exception import HCCIException

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.common.karborproxy.shell_cmd import ShellCmd
from plugins.CSBS.common.karborproxy.ssh_cmd import SShCmd

logger.init("KarborProxy")


class AlgorithmSwitching(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(AlgorithmSwitching, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.cipher_type = ParamTool(self.project_id, pod_id).get_cipher_type()
        self.proxy_util = KarborProxyOperation(project_id)
        self.ssh = SShCmd(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self._change_cipher_type()
        self._change_os_cipher()

    def _change_cipher_type(self):
        logger.info("Ssh to karborproxy node and change cipher type.")
        cmd = ShellCmd.algorithm_switchover % self.cipher_type
        node_list = self.proxy_util.get_proxy_node_list()
        if not node_list:
            logger.error("Get proxy node list failed!")
            raise HCCIException("640001", "Get proxy node list failed!")
        node = node_list[0]
        self.ssh.ssh_cmds_to_proxy(node, cmd)

    def _change_os_cipher(self):
        logger.info("Ssh to karborproxy node and change os cipher.")
        cmd = ShellCmd.change_os_cipher % self.cipher_type
        self.ssh.ssh_cmds_to_all_proxys(cmd)
