import utils.common.log as logger
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.dmk_tool import DmkTool
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("Karbor Proxy")
RETRY = 3


class CreateDmkAccount(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(CreateDmkAccount, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.param_util = BaseOps()
        self.dmk_tool = DmkTool(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        retry = 0
        error = ""
        while retry <= RETRY:
            try:
                return self._create_dmk_account()
            except Exception as err:
                logger.error(f"Execute error:{str(err)}.")
                retry += 1
                error = str(err)
                logger.error(f"Start retry:{retry}.")
        return Message(500, HCCIException(640007, str(error)))

    def _create_dmk_account(self):
        logger.info('Start to create karbor proxy dmk account.')
        params = self.param_util.get_service_cloud_param(self.project_id, "CSBS-VBS")
        dmk_account = params.get('dmk_account_proxy')
        dmk_account_tmp_pwd = params.get('tmp_dmk_account_pwd_proxy')
        dmk_account_pwd = params.get('dmk_account_pwd_proxy')
        dmk_account_group = params.get('dmk_account_group_proxy')
        self.dmk_tool.create_dmk_user(dmk_account, dmk_account_group, dmk_account_tmp_pwd, dmk_account_pwd)
        self.dmk_tool.create_dmk_proxy_account(dmk_account, dmk_account_pwd)
        logger.info('Succeed to create karbor proxy dmk account.')
        return Message(200)
