import utils.common.log as logger
from utils.business.param_util import ParamUtil
from utils.business.service_monitor.service_monitor import ServiceMonitorCfg
from utils.business.service_monitor.service_monitor import ServiceNodeCfg
from utils.business.service_monitor.service_monitor import set_service_m_cfg
from utils.common.exception import HCCIException
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class ServiceMonitor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ServiceMonitor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.param_util = ParamUtil()
        self.region_id = self.param_util.get_param_value(
            self.pod_id, "public", "region_id", "region0_id")

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            return self._config_service_monitor(pod_id)
        except Exception as err:
            logger.error(f"Execute error:{str(err)}")
            return Message(RESULT_CODE['ERROR'], HCCIException(640016, str(err)))

    def _config_service_monitor(self, pod_id):
        logger.info('Start to configure Service Monitoring.')
        karbor_ip_list = self.karbor_util.get_karbor_ip_list()[:2]
        logger.info(f'karbor ip list: {karbor_ip_list}.')
        templates = ["os_template", "cbs_server_template_id"]
        nodes_info = []
        for karbor_ip in karbor_ip_list:
            for template_id in templates:
                karbor_node = ServiceNodeCfg(karbor_ip, template_id, "CSBS-VBS_log_V200R001C30")
                nodes_info.append(karbor_node)
        service_m_cfg = ServiceMonitorCfg("CSBS-VBS-SERVER",
                                          "Cloud Backup Service Server",
                                          self.region_id,
                                          "CSBS-VBS-SERVER",
                                          "SAAS",
                                          nodes_info)
        if not set_service_m_cfg(pod_id, service_m_cfg):
            return Message(RESULT_CODE['ERROR'], HCCIException(640015))
        logger.info('Succeed to configure service monitor.')
        return Message(RESULT_CODE['SUCCESS'])
