import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob


logger.init("KarborProxy")


class PreCheckUpgradeProxyState(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckUpgradeProxyState, self).__init__(project_id, pod_id, regionid_list)
        self.proxy = KarborProxyOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            bad_service = self.proxy.check_proxy_service()
        except Exception as error:
            logger.error(f"Check KarborProxy service state fail, err_msg:{str(error)}.")
            return Message(500, HCCIException(645053))
        if bad_service:
            return Message(500, HCCIException(645054, bad_service))
        return Message(200)
