import utils.common.log as logger

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.karborproxy.shell_cmd import ShellCmd
from plugins.CSBS.common.karborproxy.ssh_cmd import SShCmd
from plugins.CSBS.common.karborproxy.project_set import project_preset

logger.init("KarborProxy")

KARBOR_CONN_PROXY_CMD = "source /opt/huawei/dj/inst/utils.sh;" \
                        "set_res_mgr_configs --agent_proxy_ip %s --dpa_deploy_mode %s;" \
                        "echo karbor conn proxy result: $?"
SET_AGENT_CMD = "source /opt/huawei/dj/inst/utils.sh;" \
                "set_res_mgr_agents --action update --type 0 --version %s;" \
                "echo set agent cmd result: $?"
SET_ASSIT_CMD = "source /opt/huawei/dj/inst/utils.sh;" \
                "set_res_mgr_agents --action update --type 1 --version %s;" \
                "echo set assit cmd result: $?"


class ConnectionKarborAndProxy(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd(project_id, pod_id)
        self.karbor_util = KarborUtil(project_id, pod_id)
        self.agent_proxy = KarborProxyOperation(project_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start configuring proxy information on the Karbor node.")
        self._config_proxy_info_to_karbor()
        logger.info("Configure Karbor information on the proxy node.")
        self._write_karbor_info_to_proxy()

    def _config_proxy_info_to_karbor(self):
        karbor_node = self.karbor_util.get_karbor_node_list()[0]
        cmd = KARBOR_CONN_PROXY_CMD % (
            self.agent_proxy.get_management_float_ip(),
            self.agent_proxy.data_protection_app_mode,
        )
        self.ssh.ssh_cmd_to_karbor(karbor_node, cmd)

        cmd = SET_AGENT_CMD % (self.agent_proxy.get_agent_assist_version())
        self.ssh.ssh_cmd_to_karbor(karbor_node, cmd)

        cmd = SET_ASSIT_CMD % (self.agent_proxy.get_agent_version())
        self.ssh.ssh_cmd_to_karbor(karbor_node, cmd)

    def _write_karbor_info_to_proxy(self):
        karbor_float_ip = self.karbor_util.get_karbor_float_ip()
        cmd = ShellCmd.conn_karbor % karbor_float_ip
        self.ssh.ssh_cmds(self.agent_proxy.karborproxy_node_list[0], cmd)
