import re

import utils.common.log as logger
import yaml
from utils.business.dmk_util import DmkApi
from utils.business.dns_util import DNSApi, DNSNodeType
from utils.business.param_util import ParamUtil
from utils.business.project_util import ProjectApi
from utils.common.exception import HCCIException

from plugins.CSBS.common.params_tool import Params


class Accounts(object):
    def __init__(self, project_id, pod_id):
        # step exec info
        self.project_id = project_id
        self.pod_id = pod_id
        params = Params(project_id, pod_id)
        self.db_param_dict = params.get_params()
        self.params = ParamUtil()
        self.dmk_api = DmkApi()

    def setpublicconfig(self):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        self.dmk_api.login_dmk(self.db_param_dict.get('dmk_floatIp'),
                               self.db_param_dict.get('dmk_ui_username'),
                               self.db_param_dict.get('dmk_ui_password'))
        new_vbs_url = \
            f"csbs-vbs-api.{self.db_param_dict.get('region_id')}.{self.db_param_dict.get('global_domain_name')}:8799"
        old_public_config = self.dmk_api.get_dmk_public_config()
        if not old_public_config:
            raise HCCIException("640005")

        old_public_vars = yaml.safe_load(old_public_config)

        if not re.search(new_vbs_url, old_public_config):
            old_public_vars['g_current_region']['vbs']['service'] = new_vbs_url
            new_public_config = yaml.dump(old_public_vars, default_flow_style=False)
            logger.info(f"The new public config is: {new_public_config}")
            self.dmk_api.dmk_set_config(config_type="public", content=new_public_config)

    def register_dns(self):
        domain_type = 'A'
        if ProjectApi().is_ipv6_project(self.project_id):
            domain_type = 'AAAA'
        domain_pre = f"csbs-vbs-api.{self.db_param_dict.get('region_id')}"
        zone = self.db_param_dict.get('global_domain_name')
        rrsets = [
            {'name': domain_pre,
             'type': domain_type,
             'records': [self.db_param_dict.get("CSBS_Float_ip1")]
             }
        ]

        dns = DNSApi()
        logger.info('Call dns.add_rrsets(), rrsets:{}'.format(rrsets))
        if not dns.add_rrsets(zone, rrsets, DNSNodeType.OM, self.pod_id):
            raise Exception(f"Register dns {domain_pre} failed.")

        shubao_lb_float_ip = self.params.get_param_value(self.pod_id, "API_Gateway",
                                                         "shubao_lb_float_ip", "shubao_lb_float_ip")

        if not shubao_lb_float_ip:
            return True

        domain_pre = f"csbs-vbs.{self.db_param_dict.get('region_id')}"
        zone = self.db_param_dict.get('global_domain_name')
        rrsets = [
            {'name': domain_pre,
             'type': domain_type,
             'records': [shubao_lb_float_ip]
             }
        ]
        dns = DNSApi()
        logger.info('Call dns.add_rrsets(), rrsets:{}'.format(rrsets))
        if not dns.add_rrsets(zone, rrsets, DNSNodeType.OM, self.pod_id):
            raise Exception(f"Register dns {domain_pre} failed.")
        return True
