import os
import time

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.software_package_util import find_software_package_by_name

from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.util import unzip_file
from plugins.CSBS.common.karborproxy.funtions import exe_shell_get_result

agent_proxy_pkg = {
    'arm': ('OceanStor_BCManager', '_AgentProxy-aarch64.tar.gz'),
    'x86': ('OceanStor_BCManager', '_AgentProxy-x86_64.tar.gz')
}
karbor_proxy_pkg = {
    'arm': ('OceanStor_BCManager', '_KarborProxy-aarch64.zip'),
    'x86': ('OceanStor_BCManager', '_KarborProxy-x86_64.zip')
}


class PkgParam:
    default_hcci_pkg_path = ParamTool.get_default_hcci_pkg_path()
    extract_karbor_proxy_path = os.path.join(default_hcci_pkg_path, "KarborProxy")

    @staticmethod
    def get_architecture(is_arm):
        return 'arm' if is_arm else 'x86'

    def find_agent_pkg(self, is_arm):
        """
        Find the agent assistant package.
        :return:
        """
        proxy_zip_file_path = self.find_karbor_proxy_zip_pkg(is_arm)
        self.unzip_karbor_proxy_zip_pkg(proxy_zip_file_path, self.extract_karbor_proxy_path)
        # 延时3s，防止未解压就开始查找agent proxy压缩包
        time.sleep(3)
        pkg_pre_name, pkg_post_name = agent_proxy_pkg.get(PkgParam.get_architecture(is_arm))
        path, name = find_software_package_by_name(pkg_pre_name, pkg_post_name)
        if not name:
            raise HCCIException(640090, pkg_pre_name + "......" + pkg_post_name)
        logger.info("[KarborProxy] find agent package succ.")
        return os.path.join(path, name), name

    @staticmethod
    def find_karbor_proxy_zip_pkg(is_arm):
        proxy_zip_pre_name, proxy_zip_post_name = karbor_proxy_pkg.get(PkgParam.get_architecture(is_arm))
        proxy_zip_path, proxy_zip_name = find_software_package_by_name(proxy_zip_pre_name, proxy_zip_post_name)
        if not proxy_zip_name:
            raise HCCIException(640090, proxy_zip_pre_name + "......" + proxy_zip_post_name)
        proxy_zip_file_path = os.path.join(proxy_zip_path, proxy_zip_name)
        return proxy_zip_file_path

    def unzip_karbor_proxy_zip_pkg(self, src, dst):
        if not os.path.isfile(src):
            raise Exception(f"{src} is not file.")
        if os.path.isdir(dst):
            self.remove_all_files_and_dirs_in_path(dst)
        unzip_file(src, dst)
        return True

    @staticmethod
    def remove_all_files_and_dirs_in_path(path):
        if os.path.isfile(path):
            os.remove(path)
            return True
        if not os.path.isdir(path):
            raise Exception(f"{path} is not directory.")
        for root, dirs, files in os.walk(path, topdown=False):
            for file in files:
                os.remove(os.path.join(root, file))
            for directory in dirs:
                os.rmdir(os.path.join(root, directory))
        os.rmdir(path)
        return True

    @staticmethod
    def is_exists_p7s_file(file_name):
        p7s_file = file_name + '.p7s'
        return os.path.isfile(p7s_file)

    @staticmethod
    def find_file(cmd):
        return exe_shell_get_result(cmd)
