import time

import utils.common.log as logger
from utils.common.exception import HCCIException

from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.agent_proxy_param import AgentProxy
from plugins.CSBS.scripts.deploy.karborproxy.config.file_path import FilePath
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.common.karborproxy.shell_cmd import ShellCmd
from plugins.CSBS.common.karborproxy.ssh_cmd import SShCmd

logger.init("eBackup KarborProxy vm")


class ConfigAgentProxyVM(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ConfigAgentProxyVM, self).__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd(project_id, pod_id)
        self.proxy_util = KarborProxyOperation(project_id)
        self.agent_proxy = AgentProxy(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("exec Uploading Data Disk Files")
        self._upload_set_disk_file()
        logger.info("Installing and Setting Data Disks")
        self._set_data_disk()
        for node in self.proxy_util.get_proxy_node_list():
            ssh_client = SshClient().create_ssh_client(node.node_ip, 'root', node.root_pwd)
            SshClient.ssh_exec_command_return(ssh_client, "rm -rf /root/SetDataDisk.sh")
            SshClient.ssh_close(ssh_client)

    def _upload_set_disk_file(self):
        retry_count = 0
        while retry_count < 20:
            try:
                self.ssh.put_file_to_all_roots(FilePath.SET_DISK_FILE)
            except HCCIException as err:
                logger.error("ssh connect failed.%s" % err)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            except Exception as err:
                logger.error("ssh connect failed.%s" % err)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            logger.info("put file succ.")
            break

    def _set_data_disk(self):
        retry_count = 0
        while retry_count < 20:
            try:
                self.ssh.ssh_root_cmds_to_all_nodes(
                    self.agent_proxy, ShellCmd.set_disk_cmd)
            except HCCIException as err:
                logger.error("ssh connect failed.%s" % err)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            except Exception as err:
                logger.error("ssh connect failed.%s" % err)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            logger.info("config set data disk succ.")
            break
