# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.business.param_util import CheckResult
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.plugin_check import dpa_oracle_plugin_check
from plugins.CSBS.common.step_base import DeployBaseSubJob


class PluginCheck(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        check_results = []
        try:
            check_results = dpa_oracle_plugin_check()
        except Exception as ex:
            logger.error(f'Check failed! {str(ex)}')
            check_result = CheckResult(
                itemname_ch='DPA插件检查',
                itemname_en='Check dpa plugin',
                status="failure",
                error_msg_cn=HCCIException(645065, str(ex)))
            check_results.append(check_result)
        return Message(200, check_results=check_results)
