import utils.common.log as logger

from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.upgrade.proxy_params_checker import ProxyParamsCheck


class KarborProxyAftCheck(DeployBaseSubJob):

    def __init__(self, project_id, pod_id, regionid_list=None):
        logger.init("KarborProxy")
        super().__init__(project_id, pod_id, regionid_list)
        self.params_checker = ProxyParamsCheck(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self.params_checker.check_proxy_status()
