import os

import utils.common.log as logger

from utils.business.apig_util import APIGOperateApi
from utils.common.exception import HCCIException
from utils.common.message import Message
from utils.constant.path_constant import SOURCES_ROOT_DIR

from plugins.CSBS.common.constant import CSBS_SERVICE_NAME, KAEBOR_EXT_PORT
from plugins.CSBS.common.upgrade.params import ParamsTools
from plugins.CSBS.common.util import get_config_content
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("CSBS-VBS")


class RegisterApiGateway(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(RegisterApiGateway, self).__init__(project_id, pod_id, regionid_list)
        self.service_name = CSBS_SERVICE_NAME
        self.param_tool = ParamsTools(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            return self._register_add_api_gateway()
        except HCCIException as err1:
            logger.error(f'Execute error: {str(err1)}.')
            return Message(500, HCCIException(645001, err1))
        except Exception as err2:
            logger.error(f'Execute error: {str(err2)}.')
            return Message(500, HCCIException(645001, err2))

    def _register_add_api_gateway(self):
        global_domain_name = self.param_tool.get_global_domain(self.region_id)
        service_domain_name = f"csbs-vbs-api.{self.region_id}.{global_domain_name}:{KAEBOR_EXT_PORT}"
        logger.info(f'The service_domain_name: {service_domain_name}.')
        api_gateway_domain_name = f"csbs-vbs.{self.region_id}.{global_domain_name}"
        logger.info(f'The api_gateway_domain_name: {api_gateway_domain_name}.')
        add_api_config = get_config_content(
            os.path.join(SOURCES_ROOT_DIR, "plugins/CSBS/conf/upgrade/add_api_config.yaml"))
        add_api_config = add_api_config % (api_gateway_domain_name, service_domain_name)
        logger.info(f"Start registering the add API,api info:{add_api_config}.")
        result = APIGOperateApi().register_apigateway(pod_id=self.pod_id,
                                                      api_content=add_api_config,
                                                      region_id=self.region_id)
        if not result:
            logger.error("Failed to register API gateway.")
            return Message(500, HCCIException(645001, ""))
        logger.info("Succeeded to register API gateway.")
        return Message(200)
