import os

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("CSBS-VBS")


class UploadPkgToDMK(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(UploadPkgToDMK, self).__init__(project_id, pod_id, regionid_list)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

          Upload Karbor upgrade package to DMK
        """
        if self.upgrade_path.target_version != self.upgrade_path.karbor_pkg_version:
            raise Exception("The karbor package is not the expected one."
                            "Please check and upload karbor package of the correct version.")
        logger.info(f"Starting to upload upgrade packages:{self.upgrade_path.karbor_pkg_name}.")
        pkg_path = os.path.join(self.upgrade_path.pkg_path, self.upgrade_path.karbor_pkg_name)
        try:
            self.dmk_client.upload_pkg2dmk(pkg_path, self.pod_id)
        except Exception as ex:
            logger.error(ex)
            return Message(500, HCCIException(645004))
        logger.info("Upload Karbor upgrade package to DMK successfully.")
        return Message(200)
