import re
import subprocess

from utils.common.param_check import check_param_ip, check_param_integer

from plugins.CSBS.common.util import check_shell_inject_args


def exe_shell_get_result(cmd):
    check_shell_inject_args(cmd)
    exc_result = subprocess.Popen(
        args=["/bin/bash", "-c", cmd],
        shell=False,
        stdout=subprocess.PIPE,
        stderr=subprocess.STDOUT
    )
    out, _ = exc_result.communicate(timeout=300)
    result = out.decode().strip()
    return result


def check_url_list(value, ip_version):
    ip_version = int(ip_version[-1])
    for sub_url in value.split(','):
        if ip_version == 4:
            urlinfo = sub_url.split(':')
        else:
            urlinfo = []
            start_index = sub_url.find('[')
            if start_index != 0:
                return False
            end_index = sub_url.find(']')
            if end_index == -1:
                return False
            urlinfo.append(sub_url[start_index + 1:end_index])
            if len(sub_url) < (end_index + 3):
                return False
            if sub_url[end_index + 1] != ':':
                return False
            urlinfo.append(sub_url[(end_index + 2):])

        if len(urlinfo) != 2:
            return False
        if not check_param_ip(urlinfo[0], ip_version):
            return False
        if not check_param_integer(urlinfo[1]):
            return False
    return True


def check_param_string(param_name):
    pattern = r"^[-a-zA-Z0-9:/_\.]{1,}$"
    match_obj = re.match(pattern, param_name)
    return bool(match_obj)
