class ShellCmd:
    set_disk_cmd = "dos2unix /root/SetDataDisk.sh;" \
                   "chmod 750 /root/SetDataDisk.sh;" \
                   "bash /root/SetDataDisk.sh vdb;" \
                   "echo Exe config disk result: $?"
    clear_history_cmd = ">~/.bash_history&&history -c;" \
                        "echo Exe clear history cmd result: $?"

    harden_cmd = "dos2unix /home/dpamanager/StandardHardening.sh;" \
                 "chmod 755 /home/dpamanager/StandardHardening.sh;" \
                 "bash /home/dpamanager/StandardHardening.sh"

    install_agent = "tar -zxvf '%s'; sh /root/agentproxy/install_scripts" \
                    "/install_agentproxy.sh install /root/sys.ini;" \
                    "echo Exe install AgentProxy result: $?"

    karbor_conn_dpa_cmd = "source /opt/huawei/dj/inst/utils.sh;" \
                          "set_res_mgr_backend --action add " \
                          "--dpa_business_float  %s --dpa_cluster %s"

    config_mode = "source /opt/huawei/dj/inst/utils.sh;" \
                  "set_res_mgr_configs --dpa_deploy_mode %s;"

    karbor_conn_proxy_cmd = "source /opt/huawei/dj/inst/utils.sh;" \
                            "set_res_mgr_configs --agent_proxy_ip %s --dpa_deploy_mode %s;" \
                            "set_res_mgr_agents --action update " \
                            "--type 0 --version %s;" \
                            "set_res_mgr_agents --action update" \
                            " --type 1 --version %s;" \
                            "echo Exe Configuring the Connection " \
                            "Between the Proxy and Karbor result: $?"

    config_dns = "cat /etc/resolv.conf |grep 'nameserver %s' || " \
                 "sed -i '$a nameserver %s'  /etc/resolv.conf;" \
                 " cat /etc/resolv.conf |grep 'nameserver %s'" \
                 " ||sed -i '$a nameserver %s'  /etc/resolv.conf;" \
                 "echo Exe config dns result: $?"

    conn_karbor = "proxython /opt/huawei-data-protection/agentproxy/bin/" \
                  "zk_operate.py config_karbor %s:8799;" \
                  "echo Exe Write karbor info to the proxy result: $?"

    update_chown = 'chown agentproxy:agentproxy /opt/huawei-data-protection' \
                   '/agentproxy/pkg/agent/*;chown agentproxy:agentproxy /opt' \
                   '/huawei-data-protection/agentproxy/pkg/agent_assistant' \
                   '/*;echo Exe Changing the Owner Group of' \
                   ' the Assistant Package result: $?'

    update_auth = 'chmod 400 /opt/huawei-data-protection' \
                  '/agentproxy/pkg/agent/*;chmod 400 /opt' \
                  '/huawei-data-protection/agentproxy/pkg/agent_assistant/*;' \
                  'echo Exe Changing the Owner Group of the Assistant Package'

    add_protected_files = 'chattr +i /opt/huawei-data-protection/' \
                          'agentproxy/pkg/agent/;' \
                          'chattr +i /opt/huawei-data-protection/agentproxy/' \
                          'pkg/agent_assistant/;' \
                          'chattr +i /opt/huawei-data-protection/agentproxy/' \
                          'pkg/agent/*;' \
                          'chattr +i /opt/huawei-data-protection/agentproxy/' \
                          'pkg/agent_assistant/*;' \
                          'echo Exe Modifying Assistant Package Permissions'

    config_ntp = "cat /etc/ntp.conf |grep 'server %s' || " \
                 "sed -i '$a server %s prefer minpoll 4 maxpoll 5'" \
                 " /etc/ntp.conf;" \
                 "cat /etc/ntp.conf |grep 'server %s' ||" \
                 " sed -i '$a server %s minpoll 4 maxpoll 5'" \
                 "  /etc/ntp.conf;" \
                 "service ntpd stop;service ntpd start;" \
                 "echo Exe config dns result: $?"

    pkg_mkdir = 'mkdir -m 700 -p /opt/huawei/dj/bin/' \
                'resource_manager/assistant_pkg;' \
                'echo Exe Creating a directory result: $?'
    mv_pkg = 'mv -f /home/djmanager/%s /opt/huawei/dj/' \
             'bin/resource_manager/assistant_pkg;' \
             'echo Exe Move file result: $?'
    update_pkg_chown = 'chown -hR openstack:openstack ' \
                       '/opt/huawei/dj/bin/resource_manager/assistant_pkg;' \
                       'echo Exe Modifying Directory Permissions result: $?'
    update_pkg_chmod = 'find /opt/huawei/dj/bin/resource_manager/' \
                       'assistant_pkg -type f -iname "*AgentAssist*" ' \
                       '| xargs chmod 400;' \
                       'echo Exe Modifying File Permissions result: $?'

    clear_alarm = "source /opt/huawei/dj/inst/utils.sh;" \
                  "clear_alarm 1020905 '%s'"

    add_i_attr = 'find /opt/huawei/dj/bin/resource_manager/' \
                 'assistant_pkg -type f -iname "*assist*" | ' \
                 'xargs chattr  +i; echo Exe File Add I Attribute result: $?'

    removes_i_attr = 'ls /opt/huawei/dj/bin/resource_manager/assistant_pkg |grep ' \
                     ' -i Agent&&find /opt/huawei/dj/bin/resource_manager/assistant_pkg -type f ' \
                     '-iname "*assist*" | xargs chattr  -i;echo 1; echo Exe File remove I ' \
                     'Attribute result: $?'

    proxy_removes_i_attr = 'chattr -i /opt/huawei-data-protection/agentproxy/pkg/agent/;' \
                           'chattr -i /opt/huawei-data-protection/agentproxy/pkg/agent_assistant/;' \
                           'ls /opt/huawei-data-protection/agentproxy/pkg/agent/ |grep -i CDM && ' \
                           'chattr -i /opt/huawei-data-protection/agentproxy/pkg/agent/*;' \
                           'ls /opt/huawei-data-protection/agentproxy/pkg/agent_assistant/ |grep -i' \
                           ' agent && chattr -i /opt/huawei-data-protection/agentproxy/pkg/agent_assistant/*;echo 1;' \
                           'echo Exe File remove I Attribute result: $?'

    config_ha = 'proxython /usr/local/bin/ha/arbitrationtool/' \
                'bin/configArb.py  %s %s %s;' \
                'echo Exe config HA result: $?'
    config_ha_clear_history = "sed -i 's#usr/local/bin/ha/arbitrationtool" \
                              "/bin/configArb.sh.*#usr/local/bin/ha/" \
                              "arbitrationtool/bin/configArb.sh" \
                              "#g' ~/.bash_history;" \
                              "echo Exe clear history cmd result: $?"
    update_iam_cer_permission = 'chown agentproxy:agentproxy /opt/huawei-data-protection/agentproxy/certs/agentproxy' \
                                '/iam_cert/*r&&chmod 600 /opt/huawei-data-protection/agentproxy/certs/agentproxy/' \
                                'iam_cert/*r&&chown agentproxy:agentproxy /opt/huawei-data-protection/agentproxy/' \
                                'certs/agentproxy/iam_cert/bak/*r&&chmod 600 /opt/huawei-data-protection/agentproxy/' \
                                'certs/agentproxy/iam_cert/bak/*r;echo Exe update cert permissions result: $?'
    update_oc_cer_permission = 'chown agentproxy:agentproxy /opt/huawei-data-protection/agentproxy/certs/agentproxy' \
                               '/oc_cert/*r&&chmod 600 /opt/huawei-data-protection/agentproxy/certs/agentproxy/' \
                               'oc_cert/*r&&chown agentproxy:agentproxy /opt/huawei-data-protection/agentproxy/' \
                               'certs/agentproxy/oc_cert/bak/*r&&chmod 600 /opt/huawei-data-protection/agentproxy/' \
                               'certs/agentproxy/oc_cert/bak/*r;echo Exe update cert permissions result: $?'

    # Restart the AgentProxy service.
    restart_agentproxy_service = "agentproxyControl -A RESTART;echo Exe " \
                                 "RESTART agentproxyControl result: $?"

    config_iam = "proxython /opt/huawei-data-protection/" \
                 "agentproxy/bin/ops_config.py iam %s;" \
                 "echo Exe config iam result: $?"

    config_op_user = "proxython /opt/huawei-data-protection/" \
                     "agentproxy/bin/ops_config.py op_service %s;" \
                     "echo Exe config op_user result: $?"

    config_alarm = "proxython /opt/huawei-data-protection/" \
                   "agentproxy/bin/ops_config.py oc %s;" \
                   "echo Exe config alarm result: $?"

    algorithm_switchover = "proxython /opt/huawei-data-protection/" \
                           "agentproxy/bin/switch_cipher_type.py %s;" \
                           "echo Exe algorithm switchover result: $?"

    change_os_cipher = "sh /opt/huawei-data-protection/root_tools/" \
                       "ops/changeOsCipher.sh %s;" \
                       "echo Exe change os cipher result: $?"

    generated_sha256 = 'proxython /opt/huawei-data-protection/' \
                       'agentproxy/bin/zk_operate.py config_pkg_sign;' \
                       'echo Exe generated sha256 result: $?'

    change_password_complexity = "sed -i 's/dcredit=.*/dcredit=0 ucredit=0 lcredit=0 ocredit=0/g' /etc/pam.d/" \
                                 "system-auth;echo updating the password complexity $?"
    update_group = 'sed -i "s/dpamanager.*/dpamanager,nobody/g" /etc/group;echo config nobody result: $?'
    config_syslog = "sed -i 's/syslog_address.*/syslog_address = %s/g' /opt/huawei-data-protection/agentproxy/conf/" \
                    "agentproxy.conf; echo Exe config syslog result: $?"
    delete_proxy_harden_files = "rm -rf /opt/huawei-data-protection/root_tools/agent_proxy"
