from functools import wraps

from utils.common.code2Msg import Code2Msg

HCS_VERSION = "8.3.X"


def _wrap_parse_code_2_msg(func):
    @wraps(func)
    def wrapper(self, code, *arg, **kwargs):
        kwargs.setdefault("bcm_hcs_version", HCS_VERSION)
        return func(self, code, *arg, **kwargs)
    return wrapper


def do_patch_code_2_msg():
    Code2Msg.code2msg = _wrap_parse_code_2_msg(Code2Msg.code2msg)
