# -*- coding:utf-8 -*-

from utils.business.project_condition_utils import get_project_condition_boolean
from utils.common.exception import HCCIException
import utils.common.log as logger

logger.init("CSBS")


def resource_calc(project_id, pod_id):
    """
    资源容量检查
    :param project_id:
    :param pod_id:
    :return: [{type:vm, host_ip:None, cpu:1, mem:2, sys_disk:20,
    sys_disk_type:local, data_disk_total:40,data_disk_type:remote},
    {type:host, host_ip:192.168.0.1, cpu:1, mem:2, sys_disk:0,
    sys_disk_type:local, data_disk_total: 0,data_disk_type:remote }]
    """
    logger.info("Begin to calculate CSBS-VBS expand resource.")
    # CSBS-VBS扩容的业务虚拟机有3个，只有两个档位，部署时默认是4U8G，120G系统盘。扩容规模固定从4U8G扩到8U16G，系统盘不变。
    expand_resource = {"type": "vm", "host_id": None, "cpu": 4, "mem": 8,
                       "sys_disk": 0, "sys_disk_type": "remote",
                       "data_disk_total": 0, "data_disk_type": "remote"}
    # karborproxy 扩容的业务虚拟机有2个，只有两个档位，部署时默认是2U4G，120G系统盘。
    # 扩容规模固定从2U4G扩到4U8G，系统盘不变。
    proxy_expand_resource = {"type": "vm", "host_id": None, "cpu": 2,
                             "mem": 4, "sys_disk": 0,
                             "sys_disk_type": "remote",
                             "data_disk_total": 0,
                             "data_disk_type": "remote"}
    condition1 = "CSBS-VBS&(!InstalledCSBS-VBS-Proxy)&(" \
                 "!ExpansionFeature_GlobalConDR)"
    condition2 = "CSBS-VBS&InstalledCSBS-VBS-Proxy" \
                 "&(!ExpansionFeature_GlobalConDR)"
    try:
        if get_project_condition_boolean(project_id, condition1):
            return [expand_resource, expand_resource, expand_resource]
        elif get_project_condition_boolean(project_id, condition2):
            return [expand_resource, expand_resource, expand_resource,
                    proxy_expand_resource, proxy_expand_resource]
        else:
            logger.error("The CSBS-VBS condition is error, please check.")
            raise Exception("The CSBS-VBS condition is error, please check.")
    except HCCIException as err:
        logger.error(f"Calculate CSBS-VBS resource error:{str(err)}")
        raise err
    except Exception as err:
        logger.error(f"Calculate CSBS-VBS resource error:{str(err)}")
        raise HCCIException('640080', str(err)) from err
