import utils.common.log as logger
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.upgrade.params_checker import ParamsChecker

logger.init("CSBS")


class PreCheckNodeParams(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(PreCheckNodeParams, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.karbor_node_list = self.karbor_util.get_karbor_node_list()
        self.ssh_client = SshClient()
        self.param_checker = ParamsChecker(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self.param_checker.check_karbor_djmanager_login_ability(self.karbor_node_list)
            self.param_checker.check_karbor_root_login_ability(self.karbor_node_list)
        except Exception as err:
            logger.error(f"Execute error:{str(err)}")
            return Message(RESULT_CODE['ERROR'], f"Failed to check karbor params, err_msg:{str(err)}.")
        return Message(RESULT_CODE['SUCCESS'])
