import utils.common.log as logger
from utils.business.service_monitor.service_monitor import ServiceMonitorCfg
from utils.business.service_monitor.service_monitor import ServiceNodeCfg
from utils.business.service_monitor.service_monitor import set_service_m_cfg
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.agent_proxy_param import AgentProxy
from plugins.CSBS.common.karborproxy.project_set import project_preset

logger.init("KarborProxy Config Service Monitor")


class ConfigServiceMonitor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.agentproxy = AgentProxy(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self.config_service_monitor()
        return Message(200)

    def config_service_monitor(self):
        logger.info("Begin to config service monitor.")

        ip_list = [self.agentproxy.karbor_proxy_ip0,
                   self.agentproxy.karbor_proxy_ip1]
        hosts = []
        templates = ["os_template", "agentproxy"]
        for node_ip in ip_list:
            for template in templates:
                agentproxy_node = ServiceNodeCfg(
                    node_ip, template, "KarborProxy_log")
                hosts.append(agentproxy_node)
        logger.info("New service node config succ.")
        service_m_cfg = ServiceMonitorCfg(
            "KarborProxy",
            "KarborProxy",
            self.agentproxy.region_id,
            "KarborProxy",
            "IAAS",
            hosts
        )
        if not set_service_m_cfg(self.pod_id, service_m_cfg):
            raise HCCIException(640099)
        logger.info("Config service monitor succ.")
