import utils.common.log as logger

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.agent_proxy_param import AgentProxyDPAInfo
from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.common.karborproxy.shell_cmd import ShellCmd
from plugins.CSBS.common.karborproxy.ssh_cmd import SShCmd

logger.init("KarborProxy")


class ConnectionKarborAndProxy(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd(project_id, pod_id)
        self.karbor_info = KarborUtil(project_id, pod_id)
        self.agent_proxy = AgentProxyDPAInfo(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start configuring proxy information on the Karbor node.")
        self._config_proxy_info_to_karbor()
        logger.info("Configure Karbor information on the proxy node.")
        self._write_karbor_info_to_proxy()

    def _config_proxy_info_to_karbor(self):
        cmd = ShellCmd.karbor_conn_proxy_cmd % (
            self.agent_proxy.management_float_ip,
            self.agent_proxy.data_protection_app_mode,
            self.agent_proxy.agent_assist_version,
            self.agent_proxy.agent_version
        )
        karbor_node = self.karbor_info.get_karbor_node_list()[0]
        self.ssh.ssh_cmd_to_karbor(karbor_node, cmd)

    def _write_karbor_info_to_proxy(self):
        karbor_float_ip = self.karbor_info.get_karbor_float_ip()
        cmd = ShellCmd.conn_karbor % karbor_float_ip
        self.ssh.ssh_root_cmds(self.agent_proxy, cmd)
