import re

import utils.common.log as logger
from utils.business.project_condition_utils import get_project_condition_boolean

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.agent_proxy_param import AgentProxyDPAInfos
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.common.karborproxy.ssh_cmd import SShCmd

logger.init("KarborProxy ParamCheck")
DEFAULT_REQUEST_TIMEOUT = 120


class ProxyCheck(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd(project_id, pod_id)
        self.agent_proxy = AgentProxyDPAInfos(project_id, pod_id)
        self.proxy_util = KarborProxyOperation(project_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self.check_karproxy_expired()
        self.check_dpa_az_available()

    def check_karproxy_expired(self):
        logger.info('[KarborProxy]: KarborProxy Expiration Check Start')
        if get_project_condition_boolean(self.agent_proxy.project_id,
                                         "InstalledCSBS-VBS-Proxy"):
            for node in self.proxy_util.get_proxy_node_list():
                self.ssh.check_node_password_expired(node)

    def check_dpa_az_available(self):
        if get_project_condition_boolean(
                self.agent_proxy.project_id, 'ExpansionAdCloudService'):
            logger.info('[KarborProxy]: AZ Check Start')
            if self.agent_proxy.az_related_to_dpa:
                self.ssh.check_az_available(self.agent_proxy)
