#!/bin/sh
set +x
DiskName=$1
COPY_ERROR=1
PVCREATE_ERROR=2
VGCREATE_ERROR=3
LVCREATE_ERROR=4
MKFS_ERROR=5
MOUNT_ERROR=6
UNMOUNT_ERROR=7

function backupfile()
{
    rm -rf /tmpeBackup
    mkdir /tmpeBackup
    mkdir /tmpeBackup/var
    mkdir /tmpeBackup/opt
    mkdir /tmpeBackup/tmp
    mkdir /tmpeBackup/home
}

function mkfsfordatadisk()
{
    pvcreate /dev/$DiskName 1>/dev/null
    if [ $? -ne 0 ]
    then
        echo "pvcreate /dev/$DiskName failed."
        return $PVCREATE_ERROR
    fi

    vgcreate VolGroup2 /dev/$DiskName 1>/dev/null
    if [ $? -ne 0 ]
    then
        echo "vgcreate VolGroup2 /dev/$DiskName failed."
        return $VGCREATE_ERROR
    fi
    
    lvcreate -L 30G -n varvolume VolGroup2 1>/dev/null
    if [ $? -ne 0 ]
    then
        echo "lvcreate -L 30G -n varvolume VolGroup2 failed."
        return $LVCREATE_ERROR
    fi
    
    lvcreate -L 60G -n optvolume VolGroup2 1>/dev/null
    if [ $? -ne 0 ]
    then
        echo "lvcreate -L 60G -n optvolume VolGroup2 failed."
        return $LVCREATE_ERROR
    fi
    
    lvcreate -L 5G  -n tmpvolume VolGroup2 1>/dev/null
    if [ $? -ne 0 ]
    then
        echo "lvcreate -L 5G  -n tmpvolume VolGroup2 failed."
        return $LVCREATE_ERROR
    fi
    
    lvcreate -L 5G  -n homevolume VolGroup2 1>/dev/null
    if [ $? -ne 0 ]
    then
        echo "lvcreate -L 5G  -n homevolume VolGroup2 failed."
        return $LVCREATE_ERROR
    fi
    echo "pvcreate vgcreate lvcreate succ."

    mkfs -t ext4 /dev/mapper/VolGroup2-varvolume 1>/dev/null|| return $MKFS_ERROR
    mkfs -t ext4 /dev/mapper/VolGroup2-optvolume 1>/dev/null|| return $MKFS_ERROR
    mkfs -t ext4 /dev/mapper/VolGroup2-tmpvolume 1>/dev/null|| return $MKFS_ERROR
    mkfs -t ext4 /dev/mapper/VolGroup2-homevolume 1>/dev/null|| return $MKFS_ERROR
    echo "mkfs succ."
}

function copyfile2datadisk()
{
    mount /dev/mapper/VolGroup2-varvolume /tmpeBackup/var || return $MOUNT_ERROR
    mount /dev/mapper/VolGroup2-optvolume /tmpeBackup/opt || return $MOUNT_ERROR
    mount /dev/mapper/VolGroup2-tmpvolume /tmpeBackup/tmp || return $MOUNT_ERROR
    mount /dev/mapper/VolGroup2-homevolume /tmpeBackup/home || return $MOUNT_ERROR
    echo "mount succ."
    
    retry_time=0
    while [ $retry_time -lt 3 ]
    do
        cp /var/* /tmpeBackup/var/ -prf
        if [ $? -ne 0 ]
        then
            retry_time=`expr $retry_time + 1`
            echo "cp /var/* /tmpeBackup/var/ -prf failed."
            rm -rf /tmpeBackup/var/*
        else
            break
        fi
    done
    if [ $retry_time -eq 3 ]
    then
        echo "cp /var/* /tmpeBackup/var/ -prf failed."
        return $COPY_ERROR
    fi
    echo "cp succ."
    
    umount /tmpeBackup/var || return $UNMOUNT_ERROR
    umount /tmpeBackup/opt || return $UNMOUNT_ERROR
    umount /tmpeBackup/tmp || return $UNMOUNT_ERROR
    umount /tmpeBackup/home || return $UNMOUNT_ERROR
    echo "umount succ."
    
    mount /dev/mapper/VolGroup2-varvolume /var || return $MOUNT_ERROR
    mount /dev/mapper/VolGroup2-optvolume /opt || return $MOUNT_ERROR
    mount /dev/mapper/VolGroup2-tmpvolume /tmp || return $MOUNT_ERROR
    mount /dev/mapper/VolGroup2-homevolume /home || return $MOUNT_ERROR
    echo "remount succ."
    
    chmod 755 /opt
    chmod 755 /home
    chmod 755 /var
    chmod 777 /tmp
    chmod o+t /tmp
    rm -rf /tmpeBackup
    echo "chmod succ."
}

function setautomount()
{
    echo "/dev/mapper/VolGroup2-optvolume /opt ext4 defaults 1 2">>/etc/fstab
    echo "/dev/mapper/VolGroup2-varvolume /var ext4 defaults 1 2">>/etc/fstab
    echo "/dev/mapper/VolGroup2-tmpvolume /tmp ext4 defaults 1 2">>/etc/fstab
    echo "/dev/mapper/VolGroup2-homevolume /home ext4 defaults 1 2">>/etc/fstab
    echo "config auto mount succ."
}

function is_fs_mounted()
{
    mount | grep '/dev/mapper/VolGroup2-varvolume on /var' 1>/dev/null 2>/dev/null
    if [ $? -ne 0 ]
    then
        return
    fi
    
    mount | grep '/dev/mapper/VolGroup2-optvolume on /opt' 1>/dev/null 2>/dev/null
    if [ $? -ne 0 ]
    then
        return
    fi
    
    mount | grep '/dev/mapper/VolGroup2-tmpvolume on /tmp' 1>/dev/null 2>/dev/null
    if [ $? -ne 0 ]
    then
        return
    fi
    
    mount | grep '/dev/mapper/VolGroup2-homevolume on /home' 1>/dev/null 2>/dev/null
    if [ $? -ne 0 ]
    then
        return
    fi
    
    exit 0
}

function main()
{
    is_fs_mounted
    backupfile
    L_RET=$?
    if [ $L_RET -ne 0 ]
    then
        exit $L_RET
    fi
    
    mkfsfordatadisk
    L_RET=$?
    if [ $L_RET -ne 0 ]
    then
        exit $L_RET
    fi
    
    copyfile2datadisk
    L_RET=$?
    if [ $L_RET -ne 0 ]
    then
        exit $L_RET
    fi
    
    setautomount
    L_RET=$?
    if [ $L_RET -ne 0 ]
    then
        exit $L_RET
    fi
}

main