import time

import utils.common.log as logger

from plugins.CSBS.common.karborproxy.agent_proxy_param import AgentProxy
from plugins.CSBS.common.karborproxy.shell_cmd import ShellCmd
from plugins.CSBS.common.karborproxy.ssh_cmd import SShCmd
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.common.upgrade.proxy_params_checker import ProxyParamsCheck


class KarborProxyConfigHA(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        logger.init("KarborProxyConfigHA")
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd(project_id, pod_id)
        self.agent_proxy = AgentProxy(project_id, pod_id)
        self.params_checker = ProxyParamsCheck(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self._config_ha_to_karborproxy()
        self._restart_omm_ha_karborproxy()
        self._check_omm_ha_status_karborproxy()

    def _config_ha_to_karborproxy(self):
        logger.info("Deployment kaborproxy ha start.")
        api_info = self.agent_proxy.get_arb_api_info()[0]
        cmd = ShellCmd.config_ha % api_info[0:3]
        self.ssh.ssh_exe_config_ha_cmd(cmd, api_info[-1])
        logger.info("Deployment kaborproxy ha success.")

    def _restart_omm_ha_karborproxy(self):
        logger.info("Deployment kaborproxy omm-ha restart.")
        restart_omm_cmd = 'omm-haControl -A RESTART'
        self.ssh.ssh_cmds_to_all_proxys(restart_omm_cmd)
        time.sleep(60)

    def _check_omm_ha_status_karborproxy(self):
        logger.info("Deployment kaborproxy omm-ha check status start.")
        self.params_checker.config_ha_retry()
