import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob


logger.init("CSBS-VBS")


class OnAutoBak(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(OnAutoBak, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """turn auto backup on

        """
        logger.info("Start to turn on Karbor Automatic Backup.")
        try:
            self.karbor_operation.operate_karbor_service(service="karbor-api", operate="stop")
            self.karbor_operation.change_operation_service(tar_status="start")
            self.karbor_operation.operate_karbor_service(service="karbor-api", operate="start")
        except Exception as err:
            logger.error(f"Failed to turn on Karbor automatic backup, reason:{str(err)}.")
            return Message(500, HCCIException(645020))
        logger.info("Turn on automatic backup function succeed.")
        return Message(200)
