import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob


logger.init("CSBS-VBS")


class PreCheckKarbor(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """check karobor before upgrade

        """
        check_results = []
        logger.info("Start to check the CSBS-VBS service status.")
        check_config_dic = self.params_store.get_check_config("PreCheckKarbor")
        try:
            check_results = \
                self.karbor_operation.check_services(check_results, check_config_dic["KarborService"])
        except Exception as err:
            logger.error("Check Karbor service failed, reason: {}.".format(str(err)))
            return Message(500, HCCIException(645016))
        try:
            check_results = \
                self.karbor_operation.check_connection_status(check_results, check_config_dic["KarborConnection"])
        except Exception as err:
            logger.error("Check Karbor connection status failed, reason: {}.".format(str(err)))
            return Message(500, HCCIException(645016))
        check_results = self.karbor_operation.check_nodes_sys_status(check_results, check_config_dic["KarborNodesSys"])
        check_results = self.karbor_operation.check_node_certs_status(check_results, check_config_dic["KarborCerts"])
        logger.info(f"Check the backup service status and check the check result:{str(check_results)}.")
        return Message(200, check_results=check_results)
