#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.upgrade_os import UpgradeOS
from plugins.CSBS.common.util import MSG_500, MSG_200
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.constant import KARBOR_IMAGE_NAME, KARBOR_PROXY_IMAGE_NAME


class UploadKvm(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.upgrade_util = UpgradeOS(self.project_id, self.pod_id, node_list=[])

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self.upgrade_util.upload_kvm(KARBOR_IMAGE_NAME)
            if get_project_condition_boolean(self.project_id, "InstalledCSBSProxy"):
                self.upgrade_util.upload_kvm(KARBOR_PROXY_IMAGE_NAME)
        except Exception as err:
            logger.error(f"Upload image failed. {err}")
            return Message(MSG_500, HCCIException("645069"))
        return Message(MSG_200)

