import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.karborproxy.karborproxy_params import ProxyDMKClient
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("KarborProxy")


class SubmitKarborProxyAfterUpgrade(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(SubmitKarborProxyAfterUpgrade, self).__init__(project_id, pod_id, regionid_list)
        self.proxy_dmk_client = ProxyDMKClient(self.project_id, self.pod_id, self.regionid_list)
        self.proxy_operation = KarborProxyOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):

        logger.info("Login dmk and call DMK to delete Proxy back file.")
        action = "[Submit] CSBS-VBS KarborProxy"

        karborproxy_pkg_version = self.proxy_operation.get_karborproxy_pkg_version()
        try:
            result = self.proxy_dmk_client.dmk_deploy_karborproxy(action, karborproxy_pkg_version)
        except Exception as err:
            logger.error(f"Failed to delete Proxy back file, reason:{str(err)}.")
            return Message(500, HCCIException(645052))
        if not result:
            logger.error("Failed to delete Proxy back file.")
            return Message(500, HCCIException(645052))
        logger.info("Delete Proxy back file successfully.")

        return Message(200)
