#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

# ================================= install ====================================
function install()
{
    log_info "Start to install Karbor."
    source /etc/bashrc
    if [[ -f "$1" ]]; then
        sh "${LINE_ROOT}/install.sh" -f "$1"
    else
        sh "${LINE_ROOT}/install.sh" -f "$(dirname "${LINE_ROOT}")/$1"
    fi
    CHECK_RESULT $? "Install karbor failed."
    log_info "Install Karbor successfully."
}

# ================================= check ======================================
function check()
{
    log_info "Start to check whether karbor has been installed successfully."

    # check karbor
    if [[ ! -f "/opt/huawei/dj/cfg/dj.version" ]];then
        CHECK_RESULT 1 "Check karbor end, install karbor failed."
    fi

    log_info "Check karbor end, karbor has been installed successfully."
}

# ================================= rollback ===================================
function rollback()
{
    log_info "Start to rollback karbor."
    [[ ! -f  /opt/huawei/dj/sbin/csbs_python ]] && exit 0
    echo -e "y\n" | csbs_python "${LINE_ROOT}/bin/srvmanager.py" uninstall
}

# ================================= main =======================================
main()
{
    if [[ $# -lt 1 ]]; then
        CHECK_RESULT 1 "Parameter error. Usage: bash install_karbor.sh [install|check|rollback]"
    fi
    case "$1" in
        install)
            install "$2"
        ;;
        check)
            check
        ;;
        rollback)
            rollback
        ;;
        *)
            CHECK_RESULT 1 "Parameter error. Usage: bash install_karbor.sh [install|check|rollback]"
        ;;
    esac
}

main "$@"
exit 0