#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="gaussdbBackup"
export PATH=/opt/huawei/dj/bin/gaussdb/app/bin:${PATH}
BACKUP_PATH="$1"
HOST_IP=$(get_info manage_ip)
if [[ "${BACKUP_PATH}" != "/opt/huawei/djbackup/manualbk" ]] && [[ "${BACKUP_PATH}" != "/opt/huawei/djbackup/db" ]];then
    exit 1
fi

function clear_backup_dir()
{
    [[ ! -d "${BACKUP_PATH}" ]] && return 0
    backup_dirs=$(find "${BACKUP_PATH}" -maxdepth 1 -type d)
    while IFS= read -r dir;do
        [[ "${dir}" != "${BACKUP_PATH}" ]] && rm -rf "${dir}"
    done <<< "${backup_dirs}"
    return 0
}

#check directory and db state before backup
function prebackup()
{
    bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh query >/dev/null 2>&1
    ECHO_RETURN $? "GaussDB is not normal on node ${HOST_IP}, can not execute backup task."
    log_info "db state is normal on node ${HOST_IP}, check successfully."
}

function create_file_hmac()
{
    export CSBS_PYTHON_DATA="$*"
    (
        echo "import os"
        echo "from kmc import kmc"
        echo "try:"
        echo "    file = os.getenv('CSBS_PYTHON_DATA')"
        echo "    kmc.API().file_hmac(0, file)"
        echo "    exit(0)"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}

#execute backup
function backup()
{
    log_info "begin to do db backup on node ${HOST_IP}."
    backup_file="${BACKUP_PATH}/backup_file_package"
    mkdir -p "${backup_file}" >/dev/null 2>&1
    log_info "initialize a backup catalog on node ${HOST_IP}."
    bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh backup >/dev/null 2>&1
    CHECK_RESULT $? "backup database failed on node ${HOST_IP}."
    tmp_dir=${backup_file}/gaussdb_backup_$(date -d today +"%Y%m%d%H%M%S%N") && mkdir -p "${tmp_dir}"
    /usr/bin/mv -f  /opt/huawei/djbackup/db/rmandatabackup.tar.gz "${tmp_dir}"
    VERSION_INFO="$(bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh version)"
    DB_VERSION=$(echo "${VERSION_INFO}" | awk -F "(" '{print $2}' | awk -F ")" '{print $1}')
    echo "${DB_VERSION}" > "${tmp_dir}/dj_and_gaussdb_version.json"
    cat /opt/huawei/dj/cfg/dj.version >> "${tmp_dir}/dj_and_gaussdb_version.json"
    tar -P -czf "${tmp_dir}/digital_certificate.tar.gz" /opt/huawei/dj/DJSecurity > /dev/null 2>&1
    CHECK_RESULT $? "backup certificate failed on node ${HOST_IP}."
    cd "${backup_file}" && tar -czf "${tmp_dir}".tar.gz "$(basename "${tmp_dir}")" > /dev/null 2>&1
    rm -rf "${tmp_dir}" > /dev/null 2>&1
    create_file_hmac "${tmp_dir}.tar.gz"
    [[ ! -f "${tmp_dir}.tar.gz.hmac" ]] && CHECK_RESULT 1 "Create File hmac failed."
    BACKUP_FILE_NAME="${BACKUP_PATH}/$(basename "${tmp_dir}").all.tar.gz"
    cd "${BACKUP_PATH}" && tar -czf "${BACKUP_FILE_NAME}" "$(basename "${backup_file}")" > /dev/null 2>&1
    rm -rf "${backup_file}" > /dev/null 2>&1
    echo_info "backup file path on node ${HOST_IP} is: ${BACKUP_FILE_NAME}"
    log_info "db backup success on node ${HOST_IP}."
}

clear_backup_dir
prebackup
backup
