#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_backup()
{
    log_info "begin backup Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old backup"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new backup"
    log_info "Finish backup Upgrade action."
}

log_info "begin backup Upgrade."
upgrade_backup
touch "${CURRENT_PATH}/backup_upgrade_finish"
log_info "Upgrade backup success."