#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"


function install_script()
{
    log_info "Init base script configuration."
    bash "${CURRENT_PATH}/root_sudo/modify_os_configuration.sh"
    CHECK_RESULT $? "modify os configuration failed."
    bash "${LINE_ROOT}/repo/install_base_platform.sh"
    CHECK_RESULT $? "install base platform failed."
    csbs_python "${CURRENT_PATH}/root_sudo/configuration_conversion_tool.py"
    CHECK_RESULT $? "conversion service configuration failed."
    log_info "Finish base script configuration."
}

function install_rsyslog()
{
    log_info "Init base rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/base
    /usr/bin/cp "${LINE_ROOT}/cfg/rsyslog_csbs.conf" /opt/huawei/dj/cfg
    CHECK_RESULT $? "Copy rsyslog_csbs.conf to cfg failed."
    log_info "Finish base rsyslog configuration."
}

function install_crontab()
{
    log_info "Init base crontab configuration."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/crontab_base.conf" /etc/cron.d/
    CHECK_RESULT $? "Copy crontab_base failed."
    cmd_retry "service cron restart" 60 5
    CHECK_RESULT $? "Restart cron failed."
    log_info "Finish base crontab configuration."
}

function install_root()
{
    log_info "Init base root configuration."
    install_sudo_conf "${CURRENT_PATH}/conf/sudo_base_conf"
    install_root_tools base "${CURRENT_PATH}/root_sudo/changeOsCipher.sh"
    install_root_tools base "${CURRENT_PATH}/root_sudo/modify_iptables_conf.sh"
    install_root_tools base "${CURRENT_PATH}/root_sudo/root_utils.sh"
    log_info "Finish base root configuration."
}

function install_tools()
{
    log_info "Init base tools configuration."
    mkdir -p /opt/huawei/dj/{tools,etc}/base
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/base
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/base/DJserviceControl.sh
    create_link /opt/huawei/dj/tools/base/kmc_update_master_key.sh
    {
        echo '#!/bin/bash'
        echo '# chkconfig: 2345 10 90'
        echo 'systemctl restart haveged'
        echo 'sudo -u openstack bash /opt/huawei/dj/tools/base/DJserviceControl.sh $@ &'
    } >/etc/init.d/DJControl
    chmod u+x /etc/init.d/DJControl && /sbin/chkconfig --add DJControl
    CHECK_RESULT $? "Add DJControl to auto start failed."
    /sbin/chkconfig --list DJControl
    CHECK_RESULT $? "Check DJControl from auto start failed."
    log_info "Finish base tools configuration."
}

function install_version()
{
    log_info "Init base version configuration."
    mkdir -p /opt/huawei/dj/versions /opt/huawei/dj/cfg
    /usr/bin/cp -f "${CURRENT_PATH}/conf/base.ver" /opt/huawei/dj/versions
    /usr/bin/cp -f "${LINE_ROOT}/cfg/dj.version" /opt/huawei/dj/cfg
    log_info "Finish base version configuration."
}

function install_permission()
{
    log_info "Init base permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/cfg/sys.ini
    set_modify_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/paas
    log_info "Finish base permission configuration."
}

function install_conf()
{
    log_info "Init base conf configuration."
    /usr/bin/cp "${LINE_ROOT}/cfg/keylist.ini" /opt/huawei/dj/cfg
    CHECK_RESULT $? "Copy keylist to cfg failed."
    /usr/bin/cp "${LINE_ROOT}/cfg/root_ca_g2.eps" /opt/huawei/dj/cfg
    CHECK_RESULT $? "Copy root_ca_g2.eps to cfg failed."
    log_info "Finish base conf configuration."
}

log_info "Start base installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish base installation."
