#!/bin/bash
function modify_etc_sudoers()
{
    #set includedir
    mkdir -p "/etc/sudoers.d"
    sed -i "/Defaults    requiretty/c #Defaults    requiretty" /etc/sudoers
    line=$(grep -n 'Defaults.*env_reset' /etc/sudoers|cut -d: -f1)
    sed -i "/Defaults.*timestamp_timeout/d" /etc/sudoers
    sed -i "${line}aDefaults    timestamp_timeout=0" /etc/sudoers
    sed -i "/Defaults.*passwd_timeout/d" /etc/sudoers
    sed -i "${line}aDefaults    passwd_timeout=1" /etc/sudoers
    sed -i "/^#includedir.*sudoers.d$/d" /etc/sudoers
    echo "#includedir /etc/sudoers.d" >> /etc/sudoers
    sed -i "/ALWAYS_SET_PATH/d"  /etc/login.defs
    echo "ALWAYS_SET_PATH=yes" >> /etc/login.defs
}

function modify_etc_sysctl_conf()
{
    # set set port range
    sed -i '/net.ipv4.ip_local_port_range =*/d' /etc/sysctl.conf
    sed -i '/kernel.shmmax=*/d' /etc/sysctl.conf
    sed -i '/kernel.shmall=*/d' /etc/sysctl.conf
    sed -i '/kernel.yama.ptrace_scope=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.ip_nonlocal_bind=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.ip_forward=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.tcp_max_syn_backlog=*/d' /etc/sysctl.conf
    sed -i '/net.ipv6.conf.all.forwarding=*/d' /etc/sysctl.conf
    sed -i '/net.ipv6.ip_nonlocal_bind=*/d' /etc/sysctl.conf
    sed -i '/kernel.sem=*/d' /etc/sysctl.conf
    totalMemKB=$(grep MemTotal /proc/meminfo | awk '{print $2}')
    totalMemBit=$((totalMemKB*1024))
    half_totlaMemBit=$((totalMemBit/2))
    {
        echo "net.ipv4.ip_local_port_range = 10240   65000"
        echo "kernel.shmmax=${half_totlaMemBit}"
        echo "kernel.shmall=${half_totlaMemBit}"
        echo "kernel.yama.ptrace_scope=2"
        echo "kernel.sem=250 512000 100 2048"
        echo "net.ipv4.ip_nonlocal_bind=1"
        echo "net.ipv4.ip_forward=1"
        echo "net.ipv4.tcp_max_syn_backlog=4096"
        echo "net.ipv6.conf.all.forwarding=0"
        echo "net.ipv6.ip_nonlocal_bind=1"
    } >> /etc/sysctl.conf
    # reload sysctl
    sysctl -p > /dev/null 2>&1
}

function modify_etc_profile_d()
{
    # set history show cmd date
    sed -i 's#HISTTIMEFORMAT.*#HISTTIMEFORMAT "%F %T  "#' /etc/profile.d/zzz_euleros_history.sh
}

function modify_etc_ntp_conf()
{
    sed -i "/maxdist/d" /etc/ntp.conf
    sed -i "/^restrict -6 default kod nomodify notrap nopeer noquery/d" /etc/ntp.conf
    sed -i "/^restrict default kod nomodify notrap nopeer noquery/d" /etc/ntp.conf
    sed -i "/^restrict 127.0.0.1/d" /etc/ntp.conf
    sed -i "/^restrict ::1/d" /etc/ntp.conf
    sed -i "/^disable monitor/d" /etc/ntp.conf
    sed -i "/^interface ignore wildcard/d" /etc/ntp.conf
    sed -i "/^.*crypto$/d" /etc/ntp.conf
    sed -i "/^.*keysdir/d" /etc/ntp.conf
    {
        echo "tos maxdist 30"
        echo "restrict -6 default kod nomodify notrap nopeer noquery"
        echo "restrict default kod nomodify notrap nopeer noquery"
        echo "restrict 127.0.0.1"
        echo "restrict -6 ::1"
        echo "disable monitor"
        echo "interface ignore wildcard"
        echo "crypto"
        echo "keysdir /etc/ntp"
    } >> /etc/ntp.conf
    cd /etc/ntp || exit 1
    rm -f ntpkey_*
    ntp-keygen -c RSA-SHA256 -m 2048
}

function modify_etc_group()
{
    if ! grep openstack /etc/group;then
        groupadd -g 51001 openstack  > /dev/null 2>&1
    fi
    if ! grep openstack /etc/passwd;then
        useradd -u 51001 -g openstack -s /sbin/nologin -d /home/openstack -m openstack > /dev/null 2>&1
    fi
    sed -i "/umask/d" /home/openstack/.bashrc
    echo "umask 077" >> /home/openstack/.bashrc
    if ! grep djmanager /etc/passwd;then
       useradd -u 51003 -g wheel -d /home/djmanager -m djmanager > /dev/null 2>&1
    fi
    sed -i "/umask/d" /home/djmanager/.bashrc
    echo "umask 077" >> /home/djmanager/.bashrc
}

function modify_etc_pamd_sudo()
{
    sudoFile=/etc/pam.d/sudo
    if grep -E "account.*include.*system-auth" "${sudoFile}" | grep ^account &>/dev/null; then
        sed -i '/account.*include.*system-auth/d' ${sudoFile}
    fi
    if ! (grep -E "account.*required.*pam_unix.so" "${sudoFile}" | grep ^account &>/dev/null); then
        echo "account     required      pam_unix.so" >> ${sudoFile}
    fi
    if ! (grep -E "account.*sufficient.*pam_localuser.so" "${sudoFile}" | grep ^account &>/dev/null); then
        echo "account     sufficient    pam_localuser.so" >> ${sudoFile}
    fi
    if ! (grep -E "account.*sufficient.*pam_succeed_if.so uid < 1000 quiet" "${sudoFile}" | grep ^account &>/dev/null); then
        echo "account     sufficient    pam_succeed_if.so uid < 1000 quiet" >> ${sudoFile}
    fi
    if ! (grep -E "\-account.*[default=bad success=ok user_unknown=ignore].*pam_sss.so" "${sudoFile}" | grep '^-account' &>/dev/null); then
        echo "-account     [default=bad success=ok user_unknown=ignore] pam_sss.so" >> ${sudoFile}
    fi
    if ! (grep -E "account.*required.*pam_permit.so" "${sudoFile}" | grep ^account &>/dev/null); then
        echo "account     required      pam_permit.so" >> ${sudoFile}
    fi
}

function modify_etc_logrotated_rsyslog() {
    syslog_logrotate_path=/etc/logrotate.d/syslog
    rsyslog_logrotate_path=/etc/logrotate.d/rsyslog
    sudo_log_path="/var/log/sudo.log"
    cron_log_path="/var/log/cron"
    if [ ! -f "$syslog_logrotate_path" ] && [ ! -f "$rsyslog_logrotate_path" ]; then
      return 0
    fi

    if [ -f "${syslog_logrotate_path}" ] && (grep -q "${cron_log_path}" "${syslog_logrotate_path}") && ! (grep -q "${sudo_log_path}" "${syslog_logrotate_path}");then
        sed -i "/\/var\/log\/cron/a\/var\/log\/sudo.log" "${syslog_logrotate_path}"
    fi
    if [ -f "${rsyslog_logrotate_path}" ] && (grep -q "${cron_log_path}" "${rsyslog_logrotate_path}") && ! (grep -q "${sudo_log_path}" "${rsyslog_logrotate_path}");then
        sed -i "/\/var\/log\/cron/a\/var\/log\/sudo.log" "${rsyslog_logrotate_path}"
    fi
}

modify_etc_sudoers
modify_etc_sysctl_conf
modify_etc_profile_d
modify_etc_ntp_conf
modify_etc_group
modify_etc_pamd_sudo
modify_etc_logrotated_rsyslog
