#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

UTIL_CONF=${LINE_ROOT}/cfg/util.conf
SYS_INI_PATH="/opt/huawei/dj/cfg/sys.ini"


function remove_old_psutil()
{
    # 涉及新的python包安装，是否需要吧之前的包移除。
    rm -rf /opt/huawei/dj/bin/python/lib/python*/site-packages/psutil*
    CHECK_RESULT $? "remove psutil failed!"
}

function install_python()
{
    mkdir -p /opt/huawei/dj && tar -xzf "${LINE_ROOT}/repo/third_party/python.tar.gz" -C /opt/huawei/dj>/dev/null 2>&1
    CHECK_RESULT $? "install python rpm failed!"
}

function upgrade_sys_ini() {
    line=$(grep -n '\[SYSTEM\]' "${SYS_INI_PATH}"|cut -d: -f1)
    default_user_pwd_hash=$(get_pwd_with_python "password" "default_user_pwd_hash" "${UTIL_CONF}")
    default_user_pwd_info="default_user_pwd_hash=${default_user_pwd_hash}"
    sed -i "/default_user_pwd/d" "${SYS_INI_PATH}"
    if ! (grep default_user_pwd_hash "${SYS_INI_PATH}");then
        sed -i "${line}a${default_user_pwd_info}" "${SYS_INI_PATH}"
    fi
    CHECK_RESULT $? "update default_user_pwd failed!"

    default_op_service_pwd=$(get_pwd_with_python "password" "default_op_service_pwd" "${UTIL_CONF}")
    default_op_service_pwd_info="default_op_service_pwd=${default_op_service_pwd}"
    if ! (grep default_op_service_pwd "${SYS_INI_PATH}");then
        sed -i "${line}a${default_op_service_pwd_info}" "${SYS_INI_PATH}"
    fi
    CHECK_RESULT $? "update default_op_service_pwd failed!"
}

function upgrade_base()
{
    sh "${CURRENT_PATH}/install.sh"  >/dev/null 2>&1
    CHECK_RESULT $? "failed to run base install when upgrade"
    sh "${CURRENT_PATH}/config.sh"  >/dev/null 2>&1
    CHECK_RESULT $? "failed to run base config when upgrade"
    log_info "upgrade base success."
}

log_info "begin base Upgrade."
remove_old_psutil
install_python
upgrade_sys_ini
upgrade_base
touch "${CURRENT_PATH}/base_upgrade_finish"
log_info "Upgrade base success."