#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="cmsControl"

function showhelp()
{
    echo "Usage: cmsControl :"
    echo "  -S ServiceState <RUN|STOP|CHANGE>"
    echo "  -A RESTART"
    echo "  -CS ComponentState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "cmsControl illegal option"
    showhelp
    exit 1
}


function component_run()
{
    echo_info "Begin to start cms...."
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/cms_server)
    if [[ -n "${queryCmd}" ]]; then
        echo_info "$(heartBeat START cms)"
        echo_info "cms process is running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        proc_manager --filename cms_server
        sleep 5
        queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/cms_server)
        if [[ -z "${queryCmd}" ]]; then
            log_warn "cms process is not running when start, error."
            continue
        fi
        echo_info "$(heartBeat START cms)"
        echo_info "start cms successfully."
        return 0
    done
    ECHO_RETURN 1 "start cms failed."
}

function component_stop()
{
    echo_info "Begin to stop cms...."
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/cms_server)
    if [[ -z "${queryCmd}" ]]; then
        echo_info "$(heartBeat STOP cms)"
        echo_info "cms process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        kill_process /opt/huawei/dj/sbin/cms_server
        sleep 5
        queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/cms_server)
        if [[ -n "${queryCmd}" ]]; then
            log_warn "cms process is running when stop, error."
            continue
        fi
        echo_info "$(heartBeat STOP cms)"
        echo_info "stop cms successfully."
        return 0
    done
    ECHO_RETURN 1 "stop cms failed."
}

function component_restart()
{
    echo_info "cmsControl component_restart begin"
    component_stop
    sleep 5
    component_run
    echo_info "cmsControl component_restart end"
}

function checkRun()
{
    queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/cms_server)
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "cms process is not running."
    fi
    echo_info "cms process is running."
    exit 0
}

while true; do
    case "$1" in
        -S) Action1=$2;shift 2;break;;
        -CS) Action2=$2;shift 2;break;;
        -A) Action3=$2;shift 2;break;;
        -h) showhelp;break;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action3}" ]; then
    component_restart
elif [ "RUN" = "${Action1}" ]; then
    component_run
elif [ "STOP" = "${Action1}" ]; then
    component_stop
elif [ "ComponentState" = "${Action2}" ];then
    checkRun
else
    args_err
fi
exit 0
