#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
# 外部输入参数使用前需要校验
# 参数为不定个数IP格式参数列表
[[ $# -eq 0 ]] && exit 1

source /opt/huawei/root_tools/base/root_utils.sh
for dns_ip in "$@";do
    check_ip "${dns_ip}" || exit 2
done

echo "# This file had been managed by dns monitor of csbs" > /etc/resolv.conf
for dns_ip in "$@";do
    echo "nameserver  ${dns_ip}" >> /etc/resolv.conf
done