#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="mo_update_cert"

function restart_rabbitmq()
{
    rabbitmqControl -S STOP
    sleep 60
    rabbitmqControl -S RUN
}

function check_and_start_rabbitmq() {
    local retry=0
    local started_times=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        # 检查当前节点是否正在运行，未运行则进行重启
        queryCmd=$(pgrep -U 51001 -f /opt/huawei/dj/bin/erlang.*rabbit)
        if [[ -z "${queryCmd}" ]]; then
            log_error "Current node rabbitmq service is stop, need to start it."
            restart_rabbitmq
        else
            if [[ ${started_times} -lt 5 ]]; then
                started_times=$((started_times+1))
                sleep 60
                log_info "The rabbitmq service is started, check times:${started_times}."
                continue
            else
                log_info "The rabbitmq service on the current node started successfully."
                exit 0
            fi
        fi
        sleep 150
    done
    log_error "The rabbitmq service on the current node fails to start."
    exit 1
}

check_and_start_rabbitmq
