#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LD_LIBRARY_PATH=/opt/huawei/dj/bin/gaussdb/app/lib:${LD_LIBRARY_PATH}
export PATH=/opt/huawei/dj/bin/gaussdb/app/bin:${PATH}
export GAUSSHOME=/opt/huawei/dj/bin/gaussdb/app
export PGDATA=/opt/huawei/dj/bin/gaussdb/data
export PGSSLCERT=/opt/huawei/dj/bin/gaussdb/cert/client.crt
export PGSSLKEY=/opt/huawei/dj/bin/gaussdb/cert/client.key
export PGSSLROOTCERT=/opt/huawei/dj/bin/gaussdb/cert/ca-cert.pem
export PGSSLMODE=require
export LOG_TAG="gaussdb_helper"


function generate_db_cert()
{
    cert_type="$1"
    password=$(get_safe_password "$2")
    /usr/bin/expect<<-EOF
    set timeout 60
    spawn gs_guc encrypt -M ${cert_type} -D ${PGDATA}
    expect {
        "Password:" {send "${password}\r"}
    }
    expect {
        "Password:" {exit 1}
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function config_gaussdb_data()
{
    rm -f /opt/huawei/dj/bin/gaussdb/data/*.key.*
    cert_path="/opt/huawei/dj/DJSecurity/server-cert/gaussdb"
    ca_path="/opt/huawei/dj/DJSecurity/server-ca"
    gaussdb_cert="/opt/huawei/dj/bin/gaussdb/cert"
    privkey_file="/opt/huawei/dj/DJSecurity/privkey/privkey.conf"
    /usr/bin/cp -f ${ca_path}/ca-cert.pem ${gaussdb_cert}/ca-cert.pem
    /usr/bin/cp -f ${cert_path}/gaussdb-cert.pem ${gaussdb_cert}/server.crt
    /usr/bin/cp -f ${cert_path}/gaussdb-cert.pem ${gaussdb_cert}/client.crt
    /usr/bin/cp -f ${cert_path}/gaussdb-key.pem ${gaussdb_cert}/server.key
    /usr/bin/cp -f ${cert_path}/gaussdb-key.pem ${gaussdb_cert}/client.key
    privkey=$(decrypt_pwd "$(awk '{print $2}' ${privkey_file})")
    generate_db_cert server "${privkey}"
    CHECK_RESULT $? "encrypt server.crt failed."
    generate_db_cert client "${privkey}"
    CHECK_RESULT $? "encrypt client.crt failed."
    /usr/bin/cp -f /opt/huawei/dj/bin/gaussdb/data/*.key.* ${gaussdb_cert}
    CHECK_RESULT $? "Copy *.key.* to ${gaussdb_cert} failed."
}
config_gaussdb_data
log_info "[init] generate db cert successful"