#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
source "${CURRENT_PATH}/utils.sh"
export LOG_TAG="csbs_install"

#######################################
# gaussdb升级过程
# 1. 由于Gaussdb是分为两个批次升级，karbor1 第一批次升级， karbor2 第二批次升级
# 2. java环境在base升级过程中已经准备完成，所以可以直接使用
# 3. 假定Karbor1当前状态为Primary， 升级过程可以分为以下几个步骤
# Karbor1:
# 1) 在begin_upgrade过程中， 使用DataSync在Karbor1完成数据备份，将数据备份至/home/djmanager/gaussdb_data目录下
# 2) Karbor1降备，Karbor2升主
# 3) Karbor1执行uninstall（需要删除data） install脚本完成卸载重装
# 4) 启动Karbor1 Gaussdb
# 以下为Post-upgrade过程
# 5) 通过openstack免密登录，将karbor用户密码修改为当前随机密码
# 6) 创建数据库用户、创建数据库
# 7) 使用DataSync在Karbor1完成数据恢复
# Karbor2:
# 1) 在begin_upgrade过程中， 使用DataSync在Karbor2完成数据备份，将数据备份至/home/djmanager/gaussdb_data目录下
# 2) Karbor2降备，Karbor1升主
# 3) Karbor2执行uninstall install脚本完成卸载重装
# 4) 启动Karbor2 Gaussdb，由omm-ha检查standby是否需要重建。
#######################################

function upgrade_gaussdb()
{
    if [[ "$(get_db_role)" == "Primary" ]];then # 本端降备，对端升主
        cmd_manager --node_ip "$(get_info manage_ip)" --cmd "swap-service" --service "omm-ha"
        sleep 10
    fi
    log_info "begin gaussdb Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old gaussdb"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new gaussdb"
    sh "${CURRENT_PATH}/config.sh"
    CHECK_RESULT $? "failed to config new gaussdb"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new gaussdb"
    log_info "Finish gaussdb Upgrade action."
}

log_info "begin gaussdb Upgrade."
upgrade_gaussdb
touch "${CURRENT_PATH}/gaussdb_upgrade_finish"
log_info "Upgrade gaussdb success."